/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.replication.logical.metadata.ConnectionInfo;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class CreateSubscriptionRequest
extends AcknowledgedRequest<CreateSubscriptionRequest> {
    private final String owner;
    private final String name;
    private final ConnectionInfo connectionInfo;
    private final List<String> publications;
    private final Settings settings;

    public CreateSubscriptionRequest(String owner, String name, ConnectionInfo connectionInfo, List<String> publications, Settings settings) {
        this.owner = owner;
        this.name = name;
        this.connectionInfo = connectionInfo;
        this.publications = publications;
        this.settings = settings;
    }

    public CreateSubscriptionRequest(StreamInput in) throws IOException {
        super(in);
        this.owner = in.readString();
        this.name = in.readString();
        this.connectionInfo = new ConnectionInfo(in);
        this.publications = List.of(in.readStringArray());
        this.settings = Settings.readSettingsFromStream(in);
    }

    public String owner() {
        return this.owner;
    }

    public String name() {
        return this.name;
    }

    public ConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public List<String> publications() {
        return this.publications;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.owner);
        out.writeString(this.name);
        this.connectionInfo.writeTo(out);
        out.writeStringArray(this.publications.toArray(new String[0]));
        Settings.writeSettingsToStream(out, this.settings);
    }
}

