/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.action.DropSubscriptionRequest;
import io.crate.replication.logical.exceptions.SubscriptionUnknownException;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.SubscriptionsMetadata;
import java.util.Collection;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DropSubscriptionAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "internal:crate:replication/logical/subscription/drop";
    public static final DropSubscriptionAction INSTANCE = new DropSubscriptionAction();

    public DropSubscriptionAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<AcknowledgedResponse> getResponseReader() {
        return AcknowledgedResponse::new;
    }

    public static ClusterState removeSubscriptionSetting(Collection<RelationName> relations, ClusterState currentState, Metadata.Builder mdBuilder) {
        Metadata metadata = currentState.metadata();
        for (RelationName relationName : relations) {
            String[] concreteIndices;
            for (String indexName : concreteIndices = IndexNameExpressionResolver.concreteIndexNames(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, relationName.indexNameOrAlias())) {
                IndexMetadata indexMetadata = currentState.metadata().index(indexName);
                assert (indexMetadata != null) : "Cannot resolve indexMetadata for relation=" + String.valueOf(relationName);
                Settings.Builder settingsBuilder = Settings.builder().put(indexMetadata.getSettings());
                settingsBuilder.remove(LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.getKey());
                mdBuilder.put(IndexMetadata.builder(indexMetadata).settingsVersion(1L + indexMetadata.getSettingsVersion()).settings(settingsBuilder));
            }
            String possibleTemplateName = PartitionName.templateName(relationName.schema(), relationName.name());
            IndexTemplateMetadata templateMetadata = currentState.metadata().templates().get(possibleTemplateName);
            if (templateMetadata == null) continue;
            IndexTemplateMetadata.Builder templateBuilder = new IndexTemplateMetadata.Builder(templateMetadata);
            Settings.Builder settingsBuilder = Settings.builder().put(templateMetadata.settings());
            settingsBuilder.remove(LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.getKey());
            mdBuilder.put(templateBuilder.settings(settingsBuilder.build()).build());
        }
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    @Singleton
    public static class TransportAction
    extends AbstractDDLTransportAction<DropSubscriptionRequest, AcknowledgedResponse> {
        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
            super(DropSubscriptionAction.NAME, transportService, clusterService, threadPool, DropSubscriptionRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-subscription");
        }

        @Override
        public ClusterStateTaskExecutor<DropSubscriptionRequest> clusterStateTaskExecutor(final DropSubscriptionRequest request) {
            return new DDLClusterStateTaskExecutor<DropSubscriptionRequest>(this){

                @Override
                protected ClusterState execute(ClusterState currentState, DropSubscriptionRequest dropSubscriptionRequest) throws Exception {
                    Metadata currentMetadata = currentState.metadata();
                    Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                    SubscriptionsMetadata oldMetadata = (SubscriptionsMetadata)mdBuilder.getCustom("subscriptions");
                    if (oldMetadata != null && oldMetadata.subscription().containsKey(request.name())) {
                        SubscriptionsMetadata newMetadata = SubscriptionsMetadata.newInstance(oldMetadata);
                        Subscription subscription = newMetadata.subscription().remove(request.name());
                        assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
                        mdBuilder.putCustom("subscriptions", newMetadata);
                        return DropSubscriptionAction.removeSubscriptionSetting(subscription.relations().keySet(), currentState, mdBuilder);
                    }
                    if (!request.ifExists()) {
                        throw new SubscriptionUnknownException(request.name());
                    }
                    return currentState;
                }
            };
        }

        @Override
        protected ClusterBlockException checkBlock(DropSubscriptionRequest request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }
}

