/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.replication.logical.action.RestoreShardRequest;
import io.crate.replication.logical.repository.PublisherRestoreService;
import java.io.IOException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class GetFileChunkAction
extends ActionType<Response> {
    public static final String NAME = "internal:crate:replication/logical/file_chunk/get";
    public static final GetFileChunkAction INSTANCE = new GetFileChunkAction();

    public GetFileChunkAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<Response> getResponseReader() {
        return Response::new;
    }

    public static class Response
    extends TransportResponse {
        private final StoreFileMetadata storeFileMetadata;
        private final long offset;
        private final BytesReference data;

        public Response(StoreFileMetadata storeFileMetadata, long offset, BytesReference data) {
            this.storeFileMetadata = storeFileMetadata;
            this.offset = offset;
            this.data = data;
        }

        public Response(StreamInput in) throws IOException {
            this.storeFileMetadata = new StoreFileMetadata(in);
            this.offset = in.readLong();
            this.data = in.readBytesReference();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.storeFileMetadata.writeTo(out);
            out.writeLong(this.offset);
            out.writeBytesReference(this.data);
        }

        public StoreFileMetadata storeFileMetadata() {
            return this.storeFileMetadata;
        }

        public long offset() {
            return this.offset;
        }

        public BytesReference data() {
            return this.data;
        }
    }

    public static class Request
    extends RestoreShardRequest<Request> {
        private final StoreFileMetadata storeFileMetadata;
        private final long offset;
        private final int length;

        public Request(String restoreUUID, DiscoveryNode node, ShardId shardId, String subscriberClusterName, StoreFileMetadata storeFileMetadata, long offset, int length) {
            super(restoreUUID, node, shardId, subscriberClusterName);
            this.storeFileMetadata = storeFileMetadata;
            this.offset = offset;
            this.length = length;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.storeFileMetadata = new StoreFileMetadata(in);
            this.offset = in.readLong();
            this.length = in.readInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.storeFileMetadata.writeTo(out);
            out.writeLong(this.offset);
            out.writeInt(this.length);
        }

        public StoreFileMetadata storeFileMetadata() {
            return this.storeFileMetadata;
        }

        public long offset() {
            return this.offset;
        }

        public int length() {
            return this.length;
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        private final IndicesService indicesService;
        private final PublisherRestoreService publisherRestoreService;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, PublisherRestoreService publisherRestoreService) {
            super(GetFileChunkAction.NAME, threadPool, clusterService, transportService, Request::new, "get");
            this.indicesService = indicesService;
            this.publisherRestoreService = publisherRestoreService;
            TransportActionProxy.registerProxyAction(transportService, GetFileChunkAction.NAME, Response::new);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response shardOperation(Request request, ShardId shardId) throws IOException {
            IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
            Store store = indexShard.store();
            byte[] buffer = new byte[request.length()];
            int bytesRead = 0;
            store.incRef();
            StoreFileMetadata fileMetadata = request.storeFileMetadata();
            try (InputStreamIndexInput currentInput = this.publisherRestoreService.openInputStream(request.restoreUUID(), request, fileMetadata.name(), fileMetadata.length());){
                long offset = request.offset();
                if (offset < fileMetadata.length()) {
                    currentInput.skip(offset);
                    bytesRead = currentInput.read(buffer);
                }
            }
            finally {
                store.decRef();
            }
            return new Response(request.storeFileMetadata(), request.offset(), new BytesArray(buffer, 0, bytesRead));
        }

        @Override
        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        @Override
        @Nullable
        protected ShardsIterator shards(ClusterState state, Request request) {
            return state.routingTable().shardRoutingTable(request.shardId()).primaryShardIt();
        }
    }
}

