/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.metadata.RelationMetadata;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.jetbrains.annotations.VisibleForTesting;

public class Publication
implements Writeable {
    private static final Logger LOGGER = LogManager.getLogger(Publication.class);
    private final String owner;
    private final boolean forAllTables;
    private final List<RelationName> tables;

    public Publication(String owner, boolean forAllTables, List<RelationName> tables) {
        assert (!forAllTables || forAllTables && tables.isEmpty()) : "If forAllTables is true, tables must be empty";
        this.owner = owner;
        this.forAllTables = forAllTables;
        this.tables = tables;
    }

    Publication(StreamInput in) throws IOException {
        this.owner = in.readString();
        this.forAllTables = in.readBoolean();
        int size = in.readVInt();
        this.tables = new ArrayList<RelationName>(size);
        for (int i = 0; i < size; ++i) {
            this.tables.add(RelationName.fromIndexName(in.readString()));
        }
    }

    public String owner() {
        return this.owner;
    }

    public boolean isForAllTables() {
        return this.forAllTables;
    }

    public List<RelationName> tables() {
        return this.tables;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.owner);
        out.writeBoolean(this.forAllTables);
        out.writeVInt(this.tables.size());
        for (RelationName table : this.tables) {
            out.writeString(table.indexNameOrAlias());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Publication that = (Publication)o;
        return this.forAllTables == that.forAllTables && this.owner.equals(that.owner) && this.tables.equals(that.tables);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.tables, this.forAllTables);
    }

    public String toString() {
        return "Publication{forAllTables=" + this.forAllTables + ", owner=" + this.owner + ", tables=" + String.valueOf(this.tables) + "}";
    }

    public Map<RelationName, RelationMetadata> resolveCurrentRelations(ClusterState state, Roles roles, Role publicationOwner, Role subscriber, String publicationName) {
        HashSet<RelationName> relations = new HashSet<RelationName>();
        if (this.isForAllTables()) {
            Metadata metadata = state.metadata();
            for (ObjectCursor cursor : metadata.templates().keys()) {
                String templateName = (String)cursor.value;
                IndexParts indexParts = IndexName.decode(templateName);
                RelationName relationName2 = indexParts.toRelationName();
                if (!indexParts.isPartitioned()) continue;
                relations.add(relationName2);
            }
            for (ObjectCursor cursor : metadata.indices().values()) {
                IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                String indexName = indexMetadata.getIndex().getName();
                IndexParts indexParts = IndexName.decode(indexName);
                if (indexParts.isPartitioned()) continue;
                relations.add(indexParts.toRelationName());
            }
        } else {
            relations.addAll(this.tables);
        }
        return relations.stream().filter(relationName -> Publication.userCanPublish(roles, relationName, publicationOwner, publicationName)).filter(relationName -> Publication.subscriberCanRead(roles, relationName, subscriber, publicationName)).map(relationName -> RelationMetadata.fromMetadata(relationName, state.metadata(), Publication.applyCustomIndexSettings(state))).collect(Collectors.toMap(RelationMetadata::name, x -> x));
    }

    @VisibleForTesting
    public static Function<IndexMetadata, IndexMetadata> applyCustomIndexSettings(ClusterState state) {
        return im -> {
            boolean softDeletes = IndexSettings.INDEX_SOFT_DELETES_SETTING.get(im.getSettings());
            if (!softDeletes) {
                LOGGER.warn("Table '{}' won't be replicated as the required table setting 'soft_deletes.enabled' is set to: {}", (Object)RelationName.fromIndexName(im.getIndex().getName()), (Object)softDeletes);
                return null;
            }
            IndexRoutingTable routingTable = state.routingTable().index(im.getIndex());
            assert (routingTable != null) : "routingTable must not be null";
            boolean isActive = routingTable.allPrimaryShardsActive();
            IndexMetadata.Builder builder = IndexMetadata.builder(im);
            return builder.settings(Settings.builder().put(im.getSettings()).put(LogicalReplicationSettings.REPLICATION_INDEX_ROUTING_ACTIVE.getKey(), isActive)).build();
        };
    }

    private static boolean subscriberCanRead(Roles roles, RelationName relationName, Role subscriber, String publicationName) {
        boolean canRead = roles.hasPrivilege(subscriber, Permission.DQL, Securable.TABLE, relationName.fqn());
        if (!canRead && LOGGER.isInfoEnabled()) {
            LOGGER.info("User {} subscribed to the publication {} doesn't have DQL privilege on the table {}, this table will not be replicated.", (Object)subscriber.name(), (Object)publicationName, (Object)relationName.fqn());
        }
        return canRead;
    }

    private static boolean userCanPublish(Roles roles, RelationName relationName, Role publicationOwner, String publicationName) {
        for (Permission permission : Permission.READ_WRITE_DEFINE) {
            if (roles.hasPrivilege(publicationOwner, permission, Securable.TABLE, relationName.fqn())) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("User {} owning publication {} doesn't have {} privilege on the table {}, this table will not be replicated.", (Object)publicationOwner.name(), (Object)publicationName, (Object)permission.name(), (Object)relationName.fqn());
            }
            return false;
        }
        return true;
    }
}

