/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public record RelationMetadata(RelationName name, List<IndexMetadata> indices, @Nullable IndexTemplateMetadata template) implements Writeable
{
    public RelationMetadata(StreamInput in) throws IOException {
        this(new RelationName(in), in.readList(IndexMetadata::readFrom), in.readOptionalWriteable(IndexTemplateMetadata::readFrom));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.name.writeTo(out);
        out.writeList(this.indices);
        out.writeOptionalWriteable(this.template);
    }

    public static RelationMetadata fromMetadata(RelationName table, Metadata metadata, Function<IndexMetadata, IndexMetadata> applyCustomIndexSettings) {
        String indexNameOrAlias = table.indexNameOrAlias();
        IndexMetadata indexMetadata = metadata.index(indexNameOrAlias);
        if (indexMetadata == null) {
            String templateName = PartitionName.templateName(table.schema(), table.name());
            IndexTemplateMetadata templateMetadata = metadata.templates().get(templateName);
            String[] concreteIndices = IndexNameExpressionResolver.concreteIndexNames(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, indexNameOrAlias);
            ArrayList<IndexMetadata> indicesMetadata = new ArrayList<IndexMetadata>(concreteIndices.length);
            for (String concreteIndex : concreteIndices) {
                IndexMetadata newIndexMetadata;
                IndexMetadata concreteIndexMetadata = metadata.index(concreteIndex);
                if (concreteIndexMetadata == null || (newIndexMetadata = applyCustomIndexSettings.apply(concreteIndexMetadata)) == null) continue;
                indicesMetadata.add(newIndexMetadata);
            }
            return new RelationMetadata(table, indicesMetadata, templateMetadata);
        }
        IndexMetadata newIndexMetadata = applyCustomIndexSettings.apply(indexMetadata);
        List<Object> indices = newIndexMetadata == null ? List.of() : List.of(newIndexMetadata);
        return new RelationMetadata(table, indices, null);
    }
}

