/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.seqno;

import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.seqno.RetentionLeaseActions;
import org.elasticsearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.elasticsearch.index.shard.ShardId;

public class RetentionLeaseHelper {
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseHelper.class);

    private static String retentionLeaseSource(String subscriberClusterName) {
        return "logical_replication:" + subscriberClusterName;
    }

    private static String retentionLeaseIdForShard(String subscriberClusterName, ShardId shardId) {
        String retentionLeaseSource = RetentionLeaseHelper.retentionLeaseSource(subscriberClusterName);
        return retentionLeaseSource + ":" + String.valueOf(shardId);
    }

    public static void addRetentionLease(ShardId shardId, long seqNo, String subscriberClusterName, Client client, ActionListener<RetentionLeaseActions.Response> listener) {
        String retentionLeaseId = RetentionLeaseHelper.retentionLeaseIdForShard(subscriberClusterName, shardId);
        RetentionLeaseActions.AddOrRenewRequest request = new RetentionLeaseActions.AddOrRenewRequest(shardId, retentionLeaseId, seqNo, RetentionLeaseHelper.retentionLeaseSource(subscriberClusterName));
        client.execute(RetentionLeaseActions.Add.INSTANCE, request).whenComplete((response, err) -> {
            if (err == null) {
                listener.onResponse((RetentionLeaseActions.Response)response);
            } else {
                Throwable t = SQLExceptions.unwrap(err);
                if (t instanceof RetentionLeaseAlreadyExistsException) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Renew retention lease as it already exists {} with {}", (Object)retentionLeaseId, (Object)seqNo);
                    }
                    RetentionLeaseHelper.renewRetentionLease(shardId, seqNo, subscriberClusterName, client, listener);
                } else {
                    listener.onFailure(Exceptions.toException((Throwable)t));
                }
            }
        });
    }

    public static void renewRetentionLease(ShardId shardId, long seqNo, String subscriberClusterName, Client client, ActionListener<RetentionLeaseActions.Response> listener) {
        String retentionLeaseId = RetentionLeaseHelper.retentionLeaseIdForShard(subscriberClusterName, shardId);
        RetentionLeaseActions.AddOrRenewRequest request = new RetentionLeaseActions.AddOrRenewRequest(shardId, retentionLeaseId, seqNo, RetentionLeaseHelper.retentionLeaseSource(subscriberClusterName));
        client.execute(RetentionLeaseActions.Renew.INSTANCE, request).whenComplete(listener);
    }

    public static void attemptRetentionLeaseRemoval(ShardId shardId, String subscriberClusterName, Client client, ActionListener<RetentionLeaseActions.Response> listener) {
        String retentionLeaseId = RetentionLeaseHelper.retentionLeaseIdForShard(subscriberClusterName, shardId);
        RetentionLeaseActions.RemoveRequest request = new RetentionLeaseActions.RemoveRequest(shardId, retentionLeaseId);
        client.execute(RetentionLeaseActions.Remove.INSTANCE, request).whenComplete((response, err) -> {
            if (err == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Removed retention lease with id - {}", (Object)retentionLeaseId);
                }
                listener.onResponse((RetentionLeaseActions.Response)response);
            } else {
                Exception e = Exceptions.toException((Throwable)SQLExceptions.unwrap(err));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception in removing retention lease", (Throwable)e);
                }
                listener.onFailure(e);
            }
        });
    }
}

