/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.data.Row;
import io.crate.expression.symbol.Symbol;
import io.crate.rest.action.ResultToXContentBuilder;
import io.crate.session.ResultReceiver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.jetbrains.annotations.Nullable;

class RestResultSetReceiver
implements ResultReceiver<XContentBuilder> {
    private final List<Symbol> outputFields;
    private final ResultToXContentBuilder builder;
    private final long startTimeNs;
    private final CompletableFuture<XContentBuilder> result = new CompletableFuture();
    private long rowCount;

    RestResultSetReceiver(XContentBuilder builder, List<Symbol> outputFields, long startTimeNs, boolean includeTypesOnResponse) throws IOException {
        this.outputFields = outputFields;
        this.startTimeNs = startTimeNs;
        this.builder = ResultToXContentBuilder.builder(builder);
        this.builder.cols(outputFields);
        if (includeTypesOnResponse) {
            this.builder.colTypes(outputFields);
        }
        this.builder.startRows();
    }

    @Override
    @Nullable
    public CompletableFuture<Void> setNextRow(Row row) {
        try {
            this.builder.addRow(row, this.outputFields.size());
            ++this.rowCount;
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void batchFinished() {
        this.fail(new IllegalStateException("Incremental result streaming not supported via HTTP"));
    }

    @Override
    public void allFinished() {
        try {
            this.result.complete(this.finishBuilder());
        }
        catch (IOException e) {
            this.result.completeExceptionally(e);
        }
    }

    @Override
    public void fail(Throwable t) {
        this.result.completeExceptionally(t);
    }

    XContentBuilder finishBuilder() throws IOException {
        return this.builder.finishRows().rowCount(this.rowCount).duration(this.startTimeNs).build();
    }

    @Override
    public CompletableFuture<XContentBuilder> completionFuture() {
        return this.result;
    }
}

