/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.role.JwtProperties;
import io.crate.role.SecureHash;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class CreateRoleRequest
extends AcknowledgedRequest<CreateRoleRequest> {
    private final String roleName;
    private final boolean isUser;
    @Nullable
    private final SecureHash secureHash;
    @Nullable
    private final JwtProperties jwtProperties;

    public CreateRoleRequest(String roleName, boolean isUser, @Nullable SecureHash attributes, @Nullable JwtProperties jwtProperties) {
        this.roleName = roleName;
        this.isUser = isUser;
        this.secureHash = attributes;
        this.jwtProperties = jwtProperties;
    }

    public String roleName() {
        return this.roleName;
    }

    public boolean isUser() {
        return this.isUser;
    }

    @Nullable
    public SecureHash secureHash() {
        return this.secureHash;
    }

    @Nullable
    public JwtProperties jwtProperties() {
        return this.jwtProperties;
    }

    public CreateRoleRequest(StreamInput in) throws IOException {
        super(in);
        this.roleName = in.readString();
        this.isUser = in.getVersion().onOrAfter(Version.V_5_6_0) ? in.readBoolean() : true;
        this.secureHash = in.readOptionalWriteable(SecureHash::readFrom);
        this.jwtProperties = in.getVersion().onOrAfter(Version.V_5_7_0) ? in.readOptionalWriteable(JwtProperties::readFrom) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.roleName);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeBoolean(this.isUser);
        }
        out.writeOptionalWriteable(this.secureHash);
        if (out.getVersion().onOrAfter(Version.V_5_7_0)) {
            out.writeOptionalWriteable(this.jwtProperties);
        }
    }
}

