/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.metadata.RelationName;
import io.crate.role.Policy;
import io.crate.role.Privilege;
import io.crate.role.Role;
import io.crate.role.RolePrivileges;
import io.crate.role.Securable;
import io.crate.role.Subject;
import io.crate.role.metadata.RolesMetadata;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.cluster.metadata.Metadata;
import org.jetbrains.annotations.Nullable;

public final class PrivilegesModifier {
    private PrivilegesModifier() {
    }

    public static long applyPrivileges(RolesMetadata rolesMetadata, Collection<String> userNames, Iterable<Privilege> newPrivileges) {
        long affectedPrivileges = 0L;
        for (String userName : userNames) {
            affectedPrivileges += PrivilegesModifier.applyPrivileges(rolesMetadata.roles(), userName, newPrivileges);
        }
        return affectedPrivileges;
    }

    private static long applyPrivileges(Map<String, Role> roles, String userName, Iterable<Privilege> newPrivileges) {
        Role role = roles.get(userName);
        assert (role != null) : "role must exist for user=" + userName;
        HashSet<Privilege> privileges = HashSet.newHashSet(role.privileges().size());
        for (Privilege privilege : role.privileges()) {
            privileges.add(privilege);
        }
        long affectedCount = 0L;
        for (Privilege newPrivilege : newPrivileges) {
            Iterator iterator = privileges.iterator();
            boolean userHadPrivilegeOnSameObject = false;
            while (iterator.hasNext()) {
                Privilege userPrivilege = (Privilege)iterator.next();
                Subject subject = userPrivilege.subject();
                if (!subject.equals(newPrivilege.subject())) continue;
                userHadPrivilegeOnSameObject = true;
                if (newPrivilege.policy().equals((Object)Policy.REVOKE)) {
                    iterator.remove();
                    ++affectedCount;
                    break;
                }
                if (userPrivilege.equals(newPrivilege)) break;
                iterator.remove();
                privileges.add(newPrivilege);
                ++affectedCount;
                break;
            }
            if (!userHadPrivilegeOnSameObject && !newPrivilege.policy().equals((Object)Policy.REVOKE)) {
                ++affectedCount;
                privileges.add(newPrivilege);
            }
            if (affectedCount <= 0L) continue;
            roles.put(userName, role.with(new RolePrivileges(privileges)));
        }
        return affectedCount;
    }

    @Nullable
    public static RolesMetadata maybeCopyAndReplaceTableIdents(RolesMetadata oldMetadata, String sourceIdent, String targetIdent) {
        boolean privilegesChanged = false;
        HashMap<String, Role> newRoles = HashMap.newHashMap(oldMetadata.roles().size());
        for (Map.Entry<String, Role> entry : oldMetadata.roles().entrySet()) {
            Role role = entry.getValue();
            HashSet<Privilege> privileges = HashSet.newHashSet(role.privileges().size());
            for (Privilege privilege : role.privileges()) {
                Subject subject = privilege.subject();
                if (subject.securable() != Securable.TABLE) {
                    privileges.add(privilege);
                    continue;
                }
                String ident = subject.ident();
                assert (ident != null) : "ident must not be null for securable 'TABLE'";
                if (ident.equals(sourceIdent)) {
                    privileges.add(new Privilege(privilege.policy(), subject.permission(), subject.securable(), targetIdent, privilege.grantor()));
                    privilegesChanged = true;
                    continue;
                }
                privileges.add(privilege);
            }
            newRoles.put(entry.getKey(), role.with(new RolePrivileges(privileges)));
        }
        if (privilegesChanged) {
            return new RolesMetadata(newRoles);
        }
        return null;
    }

    public static long dropTableOrViewPrivileges(Metadata.Builder mdBuilder, RolesMetadata rolesMetadata, String tableOrViewIdent) {
        long affectedPrivileges = 0L;
        HashMap<String, Role> newRoles = HashMap.newHashMap(rolesMetadata.roles().size());
        for (Map.Entry<String, Role> entry : rolesMetadata.roles().entrySet()) {
            Role role = entry.getValue();
            HashSet<Privilege> updatedPrivileges = new HashSet<Privilege>();
            for (Privilege privilege : role.privileges()) {
                Subject subject = privilege.subject();
                Securable securable = subject.securable();
                if ((securable == Securable.TABLE || securable == Securable.VIEW) && tableOrViewIdent.equals(subject.ident())) {
                    ++affectedPrivileges;
                    continue;
                }
                updatedPrivileges.add(privilege);
            }
            newRoles.put(role.name(), role.with(new RolePrivileges(updatedPrivileges)));
        }
        mdBuilder.putCustom("roles", new RolesMetadata(newRoles));
        return affectedPrivileges;
    }

    public static RolesMetadata swapPrivileges(RolesMetadata oldMetadata, RelationName source, RelationName target) {
        HashMap<String, Role> newRoles = HashMap.newHashMap(oldMetadata.roles().size());
        for (Map.Entry<String, Role> entry : oldMetadata.roles().entrySet()) {
            String user = entry.getKey();
            Role role = entry.getValue();
            HashSet<Privilege> updatedPrivileges = new HashSet<Privilege>();
            for (Privilege privilege : role.privileges()) {
                Subject ident = privilege.subject();
                if (ident.securable() == Securable.TABLE) {
                    if (source.fqn().equals(ident.ident())) {
                        updatedPrivileges.add(new Privilege(privilege.policy(), ident.permission(), ident.securable(), target.fqn(), privilege.grantor()));
                        continue;
                    }
                    if (target.fqn().equals(ident.ident())) {
                        updatedPrivileges.add(new Privilege(privilege.policy(), ident.permission(), ident.securable(), source.fqn(), privilege.grantor()));
                        continue;
                    }
                    updatedPrivileges.add(privilege);
                    continue;
                }
                updatedPrivileges.add(privilege);
            }
            newRoles.put(user, role.with(new RolePrivileges(updatedPrivileges)));
        }
        return new RolesMetadata(newRoles);
    }
}

