/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.session.Cursor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public final class Cursors
implements Iterable<Cursor> {
    public static final Cursors EMPTY = new Cursors(Map.of());
    private final Map<String, Cursor> cursors;

    private Cursors(Map<String, Cursor> cursors) {
        this.cursors = cursors;
    }

    public Cursors() {
        this.cursors = new HashMap<String, Cursor>();
    }

    public void add(String cursorName, Cursor cursor) {
        Cursor previous = this.cursors.put(cursorName, cursor);
        if (previous != null) {
            throw new IllegalStateException("Cursor `" + cursorName + "` already exists");
        }
    }

    public Cursor get(String cursorName) {
        Cursor cursor = this.cursors.get(cursorName);
        if (cursor == null) {
            throw new IllegalArgumentException("No cursor named `" + cursorName + "` available");
        }
        return cursor;
    }

    public int size() {
        return this.cursors.size();
    }

    public void close(Predicate<Cursor> predicate) {
        Iterator<Map.Entry<String, Cursor>> it = this.cursors.entrySet().iterator();
        while (it.hasNext()) {
            Cursor cursor = it.next().getValue();
            if (!predicate.test(cursor)) continue;
            cursor.close();
            it.remove();
        }
    }

    public void close(@Nullable String cursorName) {
        if (cursorName == null) {
            this.close((Cursor c) -> true);
        } else {
            Cursor cursor = this.cursors.remove(cursorName);
            if (cursor == null) {
                throw new IllegalArgumentException("No cursor named `" + cursorName + "` available");
            }
            cursor.close();
        }
    }

    public String toString() {
        return "Cursors{" + String.valueOf(this.cursors.keySet()) + "}";
    }

    @Override
    public Iterator<Cursor> iterator() {
        return this.cursors.values().iterator();
    }
}

