/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import com.carrotsearch.hppc.LongArrayList;
import java.util.Arrays;
import java.util.Random;

public final class Reservoir {
    public static final int NUM_SAMPLES = 30000;
    private final LongArrayList samples;
    private final int maxSamples;
    private final Random random;
    private int itemsSeen = 0;

    public Reservoir(Random random) {
        this(30000, random);
    }

    public Reservoir(int maxSamples, Random random) {
        this.samples = new LongArrayList(maxSamples);
        this.maxSamples = maxSamples;
        this.random = random;
    }

    public boolean update(long item) {
        if (this.itemsSeen == Integer.MAX_VALUE) {
            return false;
        }
        ++this.itemsSeen;
        if (this.itemsSeen <= this.maxSamples) {
            this.samples.add(item);
        } else if (this.random.nextInt(this.itemsSeen) < this.maxSamples) {
            this.samples.set(this.random.nextInt(this.maxSamples), item);
        }
        return true;
    }

    public LongArrayList samples() {
        Arrays.sort(this.samples.buffer, 0, this.samples.elementsCount);
        return this.samples;
    }
}

