/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.exceptions.ConversionException;
import io.crate.execution.dml.ArrayIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.SessionSettings;
import io.crate.protocols.postgres.parser.PgArrayParser;
import io.crate.protocols.postgres.parser.PgArrayParsingException;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import io.crate.types.JsonType;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.jetbrains.annotations.Nullable;
import org.locationtech.spatial4j.shape.Point;

public class ArrayType<T>
extends DataType<List<T>> {
    public static final ArrayType<Object> ARRAY_OF_UNDEFINED = new ArrayType<Object>(UndefinedType.INSTANCE);
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ArrayType.class);
    public static final String NAME = "array";
    public static final int ID = 100;
    private final DataType<T> innerType;
    private Streamer<List<T>> streamer;
    private final StorageSupport<List<T>> storageSupport;

    public ArrayType(final DataType<T> innerType) {
        this.innerType = Objects.requireNonNull(innerType, "Inner type must not be null.");
        StorageSupport<T> innerStorage = innerType.storageSupport();
        if (innerStorage == null) {
            this.storageSupport = null;
        } else {
            DataType<?> dataType = ArrayType.unnest(this);
            if (dataType instanceof ObjectType) {
                final ObjectType objectType = (ObjectType)dataType;
                this.storageSupport = new StorageSupport<List<T>>(this, innerStorage){

                    @Override
                    public ValueIndexer<List<? super T>> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
                        int topMostArrayDimensions = ArrayType.dimensions(innerType) + 1;
                        assert (topMostArrayDimensions == ArrayType.dimensions(ref.valueType())) : "Must not retrieve value indexer of the child array of a multi dimensional array";
                        return ArrayIndexer.of(ref, getRef);
                    }

                    @Override
                    public List<T> decode(ColumnIdent column, SourceParser sourceParser, Version tableVersion, byte[] bytes) {
                        try {
                            String col = column.leafName();
                            Map<String, Object> map = sourceParser.parse(new BytesArray(bytes), Map.of(col, objectType.innerTypes()), false);
                            if (map.isEmpty()) {
                                return List.of();
                            }
                            return (List)map.values().iterator().next();
                        }
                        catch (NotXContentException e) {
                            List<Object> list;
                            ByteBufferStreamInput in = new ByteBufferStreamInput(ByteBuffer.wrap(bytes));
                            try {
                                in.setVersion(tableVersion);
                                list = ARRAY_OF_UNDEFINED.streamer().readValueFrom(in);
                            }
                            catch (Throwable throwable) {
                                try {
                                    try {
                                        ((StreamInput)in).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (IOException io) {
                                    throw new UncheckedIOException(io);
                                }
                            }
                            ((StreamInput)in).close();
                            return list;
                        }
                    }

                    @Override
                    public boolean retrieveFromStoredFields() {
                        return true;
                    }
                };
            } else {
                this.storageSupport = new StorageSupport<List<T>>(this, innerStorage){
                    final /* synthetic */ ArrayType this$0;
                    {
                        this.this$0 = this$0;
                        super(base);
                    }

                    @Override
                    public ValueIndexer<List<T>> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
                        int topMostArrayDimensions = ArrayType.dimensions(innerType) + 1;
                        assert (topMostArrayDimensions == ArrayType.dimensions(ref.valueType())) : "Must not retrieve value indexer of the child array of a multi dimensional array";
                        return ArrayIndexer.of(ref, getRef);
                    }

                    @Override
                    public List<T> decode(ColumnIdent column, SourceParser sourceParser, Version tableVersion, byte[] bytes) {
                        List list;
                        ByteBufferStreamInput in = new ByteBufferStreamInput(ByteBuffer.wrap(bytes));
                        try {
                            in.setVersion(tableVersion);
                            list = this.this$0.streamer().readValueFrom(in);
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    ((StreamInput)in).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                List<Object> list2;
                                ByteBufferStreamInput in2 = new ByteBufferStreamInput(ByteBuffer.wrap(bytes));
                                try {
                                    in2.setVersion(tableVersion);
                                    list2 = ARRAY_OF_UNDEFINED.streamer().readValueFrom(in2);
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        try {
                                            ((StreamInput)in2).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                    catch (IOException ee) {
                                        throw new UncheckedIOException(ee);
                                    }
                                }
                                ((StreamInput)in2).close();
                                return list2;
                            }
                        }
                        ((StreamInput)in).close();
                        return list;
                    }

                    @Override
                    public boolean retrieveFromStoredFields() {
                        return true;
                    }
                };
            }
        }
    }

    public static DataType<?> makeArray(DataType<?> valueType, int numArrayDimensions) {
        DataType<?> arrayType = valueType;
        for (int i = 0; i < numArrayDimensions; ++i) {
            arrayType = new ArrayType(arrayType);
        }
        return arrayType;
    }

    @Override
    public TypeSignature getTypeSignature() {
        return new TypeSignature(NAME, List.of(this.innerType.getTypeSignature()));
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        return List.of(this.innerType);
    }

    @Override
    public Streamer<List<T>> streamer() {
        if (this.streamer == null) {
            this.streamer = new ArrayStreamer<T>(this.innerType);
        }
        return this.streamer;
    }

    public ArrayType(StreamInput in) throws IOException {
        this(DataTypes.fromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        DataTypes.toStream(this.innerType, out);
    }

    @Override
    public String getName() {
        return this.innerType.getName() + "_array";
    }

    @Override
    public int id() {
        return 100;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.ARRAY;
    }

    public final DataType<T> innerType() {
        return this.innerType;
    }

    @Override
    public List<T> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.convert(value, this.innerType, this.innerType::implicitCast, CoordinatorTxnCtx.systemTransactionContext().sessionSettings());
    }

    @Override
    public List<T> explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        return this.convert(value, this.innerType, val -> this.innerType.explicitCast(val, sessionSettings), sessionSettings);
    }

    @Override
    public List<T> sanitizeValue(Object value) {
        return this.convert(value, this.innerType, this.innerType::sanitizeValue, CoordinatorTxnCtx.systemTransactionContext().sessionSettings());
    }

    public static List<String> fromAnyArray(Object[] values) throws IllegalArgumentException {
        if (values == null) {
            return null;
        }
        ArrayList<String> array = new ArrayList<String>(values.length);
        for (Object value : values) {
            array.add(ArrayType.anyValueToString(value));
        }
        return array;
    }

    public static List<String> fromAnyArray(List<?> values) throws IllegalArgumentException {
        if (values == null) {
            return null;
        }
        ArrayList<String> array = new ArrayList<String>(values.size());
        for (Object value : values) {
            array.add(ArrayType.anyValueToString(value));
        }
        return array;
    }

    private static String anyValueToString(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Map) {
                return Strings.toString(JsonXContent.builder().map((Map)value));
            }
            if (value instanceof Collection) {
                XContentBuilder array = JsonXContent.builder().startArray();
                for (Object element : (Collection)value) {
                    array.value(element);
                }
                array.endArray();
                return Strings.toString(array);
            }
            return value.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    private List<T> convert(@Nullable Object value, DataType<T> innerType, Function<Object, T> convertInner, SessionSettings sessionSettings) {
        Map map;
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            return Lists.map((Collection)values, convertInner);
        }
        if (value instanceof Map && (map = (Map)value).isEmpty()) {
            return List.of();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return (List)PgArrayParser.parse((String)string, bytes -> convertInner.apply(new String((byte[])bytes, StandardCharsets.UTF_8)));
            }
            catch (PgArrayParsingException e) {
                byte[] utf8Bytes = string.getBytes(StandardCharsets.UTF_8);
                if (innerType instanceof JsonType || innerType instanceof ObjectType) {
                    try {
                        return ArrayType.parseJsonList(utf8Bytes, sessionSettings, innerType);
                    }
                    catch (IOException ioEx) {
                        ConversionException conversionException = new ConversionException((Object)string, innerType);
                        conversionException.addSuppressed(ioEx);
                        throw conversionException;
                    }
                }
                throw new IllegalArgumentException("Cannot parse `" + String.valueOf(value) + "` as array", e);
            }
        }
        if (value instanceof Point) {
            Point point = (Point)value;
            if (DataTypes.isNumericPrimitive(innerType)) {
                return List.of(innerType.sanitizeValue(point.getLon()), innerType.sanitizeValue(point.getLat()));
            }
        }
        return ArrayType.convertObjectArray((Object[])value, convertInner);
    }

    private static <T> List<T> parseJsonList(byte[] utf8Bytes, SessionSettings sessionSettings, DataType<T> innerType) throws IOException {
        XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, utf8Bytes);
        return Lists.map((Collection)parser.list(), value -> innerType.explicitCast(value, sessionSettings));
    }

    private static <T> ArrayList<T> convertObjectArray(Object[] values, Function<Object, T> convertInner) {
        ArrayList<T> result = new ArrayList<T>(values.length);
        for (Object o : values) {
            result.add(convertInner.apply(o));
        }
        return result;
    }

    @Override
    public int compareTo(DataType<?> o) {
        if (!(o instanceof ArrayType)) {
            return -1;
        }
        return this.innerType.compareTo(((ArrayType)o).innerType);
    }

    @Override
    public int compare(List<T> val1, List<T> val2) {
        if (val2 == null) {
            return 1;
        }
        if (val1 == null) {
            return -1;
        }
        if (val1.size() > val2.size()) {
            return 1;
        }
        if (val2.size() > val1.size()) {
            return -1;
        }
        for (int i = 0; i < val1.size(); ++i) {
            int cmp = Comparator.nullsFirst(this.innerType).compare(val1.get(i), val2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean isConvertableTo(DataType<?> other, boolean explicitCast) {
        return other.id() == 0 || other.id() == 13 || other.id() == 28 || other instanceof ArrayType && this.innerType.isConvertableTo(((ArrayType)other).innerType(), explicitCast);
    }

    @Override
    DataType<?> merge(DataType<?> other) {
        if (other instanceof ArrayType) {
            ArrayType o = (ArrayType)other;
            return new ArrayType(DataTypes.merge(this.innerType, o.innerType));
        }
        return super.merge(other);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return Objects.equals(this.innerType, arrayType.innerType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.innerType.hashCode();
        return result;
    }

    public static DataType<?> unnest(DataType<?> dataType) {
        while (dataType instanceof ArrayType) {
            dataType = ((ArrayType)dataType).innerType();
        }
        return dataType;
    }

    public static DataType<?> updateLeaf(DataType<?> type, UnaryOperator<DataType<?>> updateLeaf) {
        int dimensions = ArrayType.dimensions(type);
        DataType<?> leafType = ArrayType.unnest(type);
        return ArrayType.makeArray((DataType)updateLeaf.apply(leafType), dimensions);
    }

    public static int dimensions(DataType<?> type) {
        int dimensions = 0;
        while (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            type = arrayType.innerType;
            ++dimensions;
        }
        return dimensions;
    }

    @Override
    public ColumnType<Expression> toColumnType(@Nullable Supplier<List<ColumnDefinition<Expression>>> convertChildColumn) {
        return new CollectionColumnType(this.innerType.toColumnType(convertChildColumn));
    }

    @Override
    public StorageSupport storageSupport() {
        return this.storageSupport;
    }

    @Override
    public long valueBytes(List<T> values) {
        if (values == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
        DataType<T> dataType = this.innerType;
        if (dataType instanceof FixedWidthType) {
            FixedWidthType fixedWidthType = (FixedWidthType)((Object)dataType);
            return (long)fixedWidthType.fixedSize() * (long)values.size();
        }
        long bytes = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        for (T value : values) {
            bytes += this.innerType.valueBytes(value);
        }
        return bytes;
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.innerType.ramBytesUsed();
    }

    @Override
    public ColumnStatsSupport<List<T>> columnStatsSupport() {
        return ColumnStatsSupport.composite(this);
    }

    @Override
    public ColumnPolicy columnPolicy() {
        return this.innerType.columnPolicy();
    }

    static class ArrayStreamer<T>
    implements Streamer<List<T>> {
        private final DataType<T> innerType;

        ArrayStreamer(DataType<T> innerType) {
            this.innerType = innerType;
        }

        @Override
        public List<T> readValueFrom(StreamInput in) throws IOException {
            int size = in.readVInt();
            if (size == 0) {
                return null;
            }
            ArrayList<T> values = new ArrayList<T>(--size);
            Streamer<T> streamer = this.innerType.streamer();
            for (int i = 0; i < size; ++i) {
                values.add(streamer.readValueFrom(in));
            }
            return values;
        }

        @Override
        public void writeValueTo(StreamOutput out, List<T> values) throws IOException {
            if (values == null) {
                out.writeVInt(0);
                return;
            }
            out.writeVInt(values.size() + 1);
            Streamer<T> streamer = this.innerType.streamer();
            for (T value : values) {
                streamer.writeValueTo(out, value);
            }
        }
    }
}

