/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.execution.dml.BooleanIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.FixedWidthType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BooleanType
extends DataType<Boolean>
implements Streamer<Boolean>,
FixedWidthType {
    public static final int ID = 3;
    public static final BooleanType INSTANCE = new BooleanType();
    private static final EqQuery<Boolean> EQ_QUERY = new EqQuery<Boolean>(){

        private static BytesRef indexedValue(Boolean value) {
            if (value == null) {
                return null;
            }
            return value != false ? new BytesRef((CharSequence)"T") : new BytesRef((CharSequence)"F");
        }

        @Override
        public Query termQuery(String field, Boolean value, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return new TermQuery(new Term(field, 1.indexedValue(value)));
            }
            assert (hasDocValues) : "hasDocValues must be true for Boolean types since 'columnstore=false' is not supported.";
            return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)(value != false ? 1L : 0L));
        }

        @Override
        public Query rangeQuery(String field, Boolean lowerTerm, Boolean upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            assert (isIndexed || hasDocValues) : "hasDocValues must be true for Boolean types since 'columnstore=false' is not supported.";
            if (upperTerm == null) {
                includeUpper = true;
                upperTerm = true;
            }
            if (lowerTerm == null) {
                includeLower = true;
                lowerTerm = false;
            }
            boolean matchTrue = true;
            boolean matchFalse = true;
            if (includeLower) {
                if (lowerTerm.booleanValue()) {
                    matchFalse = false;
                }
            } else if (lowerTerm.booleanValue()) {
                matchFalse = false;
                matchTrue = false;
            } else {
                matchFalse = false;
            }
            if (includeUpper) {
                if (!upperTerm.booleanValue()) {
                    matchTrue = false;
                }
            } else if (!upperTerm.booleanValue()) {
                matchTrue = false;
                matchFalse = false;
            } else {
                matchTrue = false;
            }
            if (matchTrue && matchFalse) {
                return new FieldExistsQuery(field);
            }
            if (matchTrue) {
                return this.termQuery(field, Boolean.TRUE, hasDocValues, isIndexed);
            }
            if (matchFalse) {
                return this.termQuery(field, Boolean.FALSE, hasDocValues, isIndexed);
            }
            return new MatchNoDocsQuery();
        }

        @Override
        public Query termsQuery(String field, List<Boolean> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return new TermInSetQuery(field, (Collection)Lists.map(nonNullValues, v -> 1.indexedValue(v)));
            }
            assert (hasDocValues) : "hasDocValues must be true for Boolean types since 'columnstore=false' is not supported.";
            return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])nonNullValues.stream().mapToLong(v -> v != false ? 1L : 0L).toArray());
        }
    };
    private static final StorageSupport<Boolean> STORAGE = new StorageSupport<Boolean>(true, false, EQ_QUERY){

        @Override
        public ValueIndexer<Boolean> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new BooleanIndexer(ref);
        }
    };
    private static final Map<String, Boolean> BOOLEAN_MAP = Map.ofEntries(Map.entry("f", false), Map.entry("false", false), Map.entry("n", false), Map.entry("no", false), Map.entry("off", false), Map.entry("0", false), Map.entry("t", true), Map.entry("true", true), Map.entry("y", true), Map.entry("yes", true), Map.entry("on", true), Map.entry("1", true));

    private BooleanType() {
    }

    @Override
    public int id() {
        return 3;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.BOOLEAN;
    }

    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    public Streamer<Boolean> streamer() {
        return this;
    }

    @Override
    public Boolean implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof String) {
            String str = (String)value;
            return this.booleanFromString(str);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return this.booleanFromNumber(number);
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Boolean sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        return this.booleanFromNumber((Number)value);
    }

    private Boolean booleanFromString(String value) {
        String lowerValue = value.toLowerCase(Locale.ENGLISH);
        Boolean boolValue = BOOLEAN_MAP.get(lowerValue);
        if (boolValue == null) {
            throw new IllegalArgumentException("Can't convert \"" + value + "\" to boolean");
        }
        return boolValue;
    }

    private Boolean booleanFromNumber(Number value) {
        if (value.doubleValue() > 0.0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public int compare(Boolean val1, Boolean val2) {
        return Boolean.compare(val1, val2);
    }

    @Override
    public Boolean readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalBoolean();
    }

    @Override
    public void writeValueTo(StreamOutput out, Boolean v) throws IOException {
        out.writeOptionalBoolean(v);
    }

    @Override
    public int fixedSize() {
        return 8;
    }

    @Override
    public long valueBytes(Boolean value) {
        return 8L;
    }

    @Override
    public StorageSupport<Boolean> storageSupport() {
        return STORAGE;
    }

    @Override
    public ColumnStatsSupport<Boolean> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(Boolean.class, this);
    }
}

