/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.common.StringUtils;
import io.crate.execution.dml.FulltextIndexer;
import io.crate.execution.dml.StringIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.SessionSettings;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import io.crate.types.StringType;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class CharacterType
extends StringType {
    public static final String NAME = "character";
    public static final int ID = 27;
    public static final CharacterType INSTANCE = new CharacterType();
    private final StorageSupport<Object> storageSupport;

    private StorageSupport<Object> storageSupport(int lengthLimit) {
        return new StorageSupport<Object>(this, true, true, (EqQuery)new StringType.StringEqQuery(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String s = (String)value;
                return this.stripTrailingBlankPadding(StringUtils.padEnd((String)s, (int)lengthLimit, (char)' '));
            }
            return this.stripTrailingBlankPadding(StringUtils.padEnd((String)((BytesRef)value).utf8ToString(), (int)lengthLimit, (char)' '));
        })){

            @Override
            public ValueIndexer<Object> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
                return switch (ref.indexType()) {
                    default -> throw new MatchException(null, null);
                    case IndexType.FULLTEXT -> new FulltextIndexer(ref);
                    case IndexType.NONE, IndexType.PLAIN -> new StringIndexer(ref);
                };
            }
        };
    }

    public static CharacterType of(List<Integer> parameters) {
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("The character type can only have a single parameter value, received: " + parameters.size());
        }
        return CharacterType.of(parameters.get(0));
    }

    public static CharacterType of(int lengthLimit) {
        if (lengthLimit <= 0) {
            throw new IllegalArgumentException("The character type length must be at least 1, received: " + lengthLimit);
        }
        return new CharacterType(lengthLimit);
    }

    public CharacterType(StreamInput in) throws IOException {
        this(in.readInt());
    }

    private CharacterType(int lengthLimit) {
        super(lengthLimit);
        this.storageSupport = this.storageSupport(lengthLimit);
    }

    private CharacterType() {
        this(1);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int id() {
        return 27;
    }

    @Override
    public boolean unbound() {
        return false;
    }

    @Override
    public String valueForInsert(String value) {
        if (value == null) {
            return null;
        }
        if (((String)value).length() == this.lengthLimit) {
            return value;
        }
        if (((String)value).length() < this.lengthLimit) {
            return StringUtils.padEnd((String)value, (int)this.lengthLimit, (char)' ');
        }
        if (StringUtils.isBlank((String)value, (int)this.lengthLimit, (int)((String)value).length())) {
            return ((String)value).substring(0, this.lengthLimit);
        }
        if (((String)value).length() > 20) {
            value = ((String)value).substring(0, 20) + "...";
        }
        throw new IllegalArgumentException("'" + (String)value + "' is too long for the character type of length: " + this.lengthLimit);
    }

    @Override
    public String implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        String s = this.cast(value);
        if (s != null) {
            return StringUtils.padEnd((String)s, (int)this.lengthLimit, (char)' ');
        }
        return s;
    }

    @Override
    public String explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        String string = this.cast(value);
        if (string.length() <= this.lengthLimit) {
            return StringUtils.padEnd((String)string, (int)this.lengthLimit, (char)' ');
        }
        return string.substring(0, this.lengthLimit);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.lengthLimit);
    }

    @Override
    public ColumnType<Expression> toColumnType(@Nullable Supplier<List<ColumnDefinition<Expression>>> convertChildColumn) {
        return new ColumnType(NAME, List.of(Integer.valueOf(this.lengthLimit)));
    }

    @Override
    public Integer characterMaximumLength() {
        return this.lengthLimit;
    }

    @Override
    public TypeSignature getTypeSignature() {
        if (this.lengthLimit == 1) {
            return new TypeSignature(NAME);
        }
        return new TypeSignature(NAME, List.of(TypeSignature.of(this.lengthLimit)));
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        return List.of(DataTypes.INTEGER);
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.CHARACTER;
    }

    @Override
    public void addMappingOptions(Map<String, Object> mapping) {
        mapping.put("length_limit", this.lengthLimit);
        mapping.put("blank_padding", true);
    }

    @Override
    public int compare(String val1, String val2) {
        return this.stripTrailingBlankPadding(StringUtils.padEnd((String)val1, (int)this.lengthLimit, (char)' ')).compareTo(this.stripTrailingBlankPadding(StringUtils.padEnd((String)val2, (int)this.lengthLimit, (char)' ')));
    }

    @Override
    public StorageSupport<Object> storageSupport() {
        return this.storageSupport;
    }

    private String stripTrailingBlankPadding(String s) {
        int idx = s.length();
        int i = idx - 1;
        while (i >= this.lengthLimit && Character.isSpaceChar(s.charAt(i))) {
            idx = i--;
        }
        return s.substring(0, idx);
    }
}

