/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import ch.randelshofer.fastdoubleparser.JavaFloatParser;
import io.crate.Streamer;
import io.crate.execution.dml.FloatIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.FixedWidthType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FloatType
extends DataType<Float>
implements Streamer<Float>,
FixedWidthType {
    public static final FloatType INSTANCE = new FloatType();
    public static final int ID = 7;
    public static final int PRECISION = 24;
    public static final int FLOAT_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Float.class);
    private static final StorageSupport<Float> STORAGE = new StorageSupport<Float>(true, true, (EqQuery)new EqQuery<Float>(){

        @Override
        public Query termQuery(String field, Float value, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return FloatPoint.newExactQuery((String)field, (float)value.floatValue());
            }
            if (hasDocValues) {
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.floatToSortableInt((float)value.floatValue()));
            }
            return null;
        }

        @Override
        public Query rangeQuery(String field, Float lowerTerm, Float upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            float upper;
            float lower;
            if (lowerTerm == null) {
                lower = Float.NEGATIVE_INFINITY;
            } else {
                float f = lower = includeLower ? lowerTerm.floatValue() : FloatPoint.nextUp((float)lowerTerm.floatValue());
            }
            if (upperTerm == null) {
                upper = Float.POSITIVE_INFINITY;
            } else {
                float f = upper = includeUpper ? upperTerm.floatValue() : FloatPoint.nextDown((float)upperTerm.floatValue());
            }
            if (isIndexed) {
                return FloatPoint.newRangeQuery((String)field, (float)lower, (float)upper);
            }
            if (hasDocValues) {
                return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.floatToSortableInt((float)lower), (long)NumericUtils.floatToSortableInt((float)upper));
            }
            return null;
        }

        @Override
        public Query termsQuery(String field, List<Float> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return FloatPoint.newSetQuery((String)field, nonNullValues);
            }
            if (hasDocValues) {
                return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])nonNullValues.stream().mapToLong(NumericUtils::floatToSortableInt).toArray());
            }
            return null;
        }
    }){

        @Override
        public ValueIndexer<Float> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new FloatIndexer(ref);
        }
    };
    private static final BigDecimal MAX = BigDecimal.valueOf(3.4028234663852886E38);
    private static final BigDecimal MIN = BigDecimal.valueOf(-3.4028234663852886E38);

    private FloatType() {
    }

    @Override
    public int id() {
        return 7;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.FLOAT;
    }

    @Override
    public String getName() {
        return "real";
    }

    @Override
    public Integer numericPrecision() {
        return 24;
    }

    @Override
    public Streamer<Float> streamer() {
        return this;
    }

    @Override
    public Float implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f;
        }
        if (value instanceof String) {
            String s = (String)value;
            return Float.valueOf(JavaFloatParser.parseFloat((CharSequence)s));
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            if (MAX.compareTo(bigDecimalValue) <= 0 || MIN.compareTo(bigDecimalValue) >= 0) {
                throw new IllegalArgumentException("float value out of range: " + String.valueOf(value));
            }
            return Float.valueOf(bigDecimalValue.floatValue());
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            float val = number.floatValue();
            if (Float.isInfinite(val) && !Double.isInfinite(number.doubleValue())) {
                throw new IllegalArgumentException("float value out of range: " + String.valueOf(value));
            }
            return Float.valueOf(val);
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Float sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f;
        }
        return Float.valueOf(((Number)value).floatValue());
    }

    @Override
    public int compare(Float val1, Float val2) {
        return Float.compare(val1.floatValue(), val2.floatValue());
    }

    @Override
    public Float readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Float.valueOf(in.readFloat());
    }

    @Override
    public void writeValueTo(StreamOutput out, Float v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeFloat(v.floatValue());
        }
    }

    @Override
    public int fixedSize() {
        return FLOAT_SIZE;
    }

    @Override
    public StorageSupport<Float> storageSupport() {
        return STORAGE;
    }

    @Override
    public ColumnStatsSupport<Float> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(Float.class, this);
    }

    @Override
    public long valueBytes(Float value) {
        return FLOAT_SIZE;
    }
}

