/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.metadata.settings.SessionSettings;
import io.crate.types.DataType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public final class JsonType
extends DataType<String>
implements Streamer<String> {
    public static final int ID = 26;
    public static final JsonType INSTANCE = new JsonType();

    @Override
    public int compare(String o1, String o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int id() {
        return 26;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.UNCHECKED_OBJECT;
    }

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public Streamer<String> streamer() {
        return this;
    }

    @Override
    public String sanitizeValue(Object value) {
        return (String)value;
    }

    @Override
    public String readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalString();
    }

    @Override
    public void writeValueTo(StreamOutput out, String v) throws IOException {
        out.writeOptionalString(v);
    }

    @Override
    public String implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return (String)value;
    }

    @Override
    public String explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        if (value instanceof Map) {
            Map map = (Map)value;
            try {
                return Strings.toString(JsonXContent.builder().map(map));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (String)value;
    }

    @Override
    public long valueBytes(String value) {
        return RamUsageEstimator.sizeOf((String)value);
    }
}

