/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.EqQuery;
import java.util.List;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.Query;

public class LongEqQuery
implements EqQuery<Long> {
    @Override
    public Query termQuery(String field, Long value, boolean hasDocValues, boolean isIndexed) {
        if (isIndexed) {
            return LongPoint.newExactQuery((String)field, (long)value);
        }
        if (hasDocValues) {
            return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)value);
        }
        return null;
    }

    @Override
    public Query rangeQuery(String field, Long lowerTerm, Long upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
        long upper;
        long lower;
        long l = lowerTerm == null ? Long.MIN_VALUE : (lower = includeLower ? lowerTerm : lowerTerm + 1L);
        long l2 = upperTerm == null ? Long.MAX_VALUE : (upper = includeUpper ? upperTerm : upperTerm - 1L);
        if (isIndexed) {
            return LongPoint.newRangeQuery((String)field, (long)lower, (long)upper);
        }
        if (hasDocValues) {
            return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)lower, (long)upper);
        }
        return null;
    }

    @Override
    public Query termsQuery(String field, List<Long> nonNullValues, boolean hasDocValues, boolean isIndexed) {
        if (isIndexed) {
            return LongPoint.newSetQuery((String)field, nonNullValues);
        }
        if (hasDocValues) {
            return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])nonNullValues.stream().mapToLong(Long::longValue).toArray());
        }
        return null;
    }
}

