/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.BinaryColumnReference;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.NumericColumnReference;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.NumericEqQuery;
import io.crate.types.NumericType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.jetbrains.annotations.NotNull;

public final class NumericStorage
extends StorageSupport<BigDecimal> {
    public static final int COMPACT_PRECISION = 18;
    public static final long COMPACT_MIN_VALUE = -999999999999999999L;
    public static final long COMPACT_MAX_VALUE = 999999999999999999L;
    private final NumericType type;

    public NumericStorage(NumericType numericType) {
        super(true, true, NumericEqQuery.of(numericType));
        this.type = numericType;
    }

    @Override
    public ValueIndexer<? super BigDecimal> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
        DataType<?> type = ArrayType.unnest(ref.valueType());
        assert (type instanceof NumericType) : "ValueIndexer on NumericStorage can only be used for numeric types";
        NumericType numericType = (NumericType)type;
        Integer precision = numericType.numericPrecision();
        if (precision == null || numericType.scale() == null) {
            throw new UnsupportedOperationException("NUMERIC type requires precision and scale to support storage");
        }
        if (precision <= 18) {
            return new CompactNumericIndexer(ref);
        }
        return new LargeNumericIndexer(ref, numericType);
    }

    @Override
    public BigDecimal decode(ColumnIdent column, SourceParser sourceParser, Version tableVersion, byte[] bytes) {
        BigInteger bigInt = NumericUtils.sortableBytesToBigInt((byte[])bytes, (int)0, (int)bytes.length);
        Integer scale = this.type.scale();
        return new BigDecimal(bigInt, scale == null ? 0 : scale, this.type.mathContext());
    }

    @Override
    public BigDecimal decode(long input) {
        BigInteger bigInt = BigInteger.valueOf(input);
        Integer scale = this.type.scale();
        return new BigDecimal(bigInt, scale == null ? 0 : scale, this.type.mathContext());
    }

    public static LuceneCollectorExpression<BigDecimal> getCollectorExpression(String fqn, final NumericType type) {
        Integer precision = type.numericPrecision();
        final MathContext mathContext = type.mathContext();
        if (precision == null || precision > 18) {
            return new BinaryColumnReference<BigDecimal>(fqn){

                @Override
                protected BigDecimal convert(BytesRef input) {
                    BigInteger bigInt = NumericUtils.sortableBytesToBigInt((byte[])input.bytes, (int)input.offset, (int)input.length);
                    Integer scale = type.scale();
                    return new BigDecimal(bigInt, scale == null ? 0 : scale, mathContext);
                }
            };
        }
        return new NumericColumnReference<BigDecimal>(fqn){

            @Override
            protected BigDecimal convert(long input) {
                BigInteger bigInt = BigInteger.valueOf(input);
                Integer scale = type.scale();
                return new BigDecimal(bigInt, scale == null ? 0 : scale, mathContext);
            }
        };
    }

    private static class CompactNumericIndexer
    extends BaseNumericIndexer {
        private CompactNumericIndexer(Reference ref) {
            super(ref);
        }

        @Override
        public void indexValue(@NotNull BigDecimal value, IndexDocumentBuilder docBuilder) throws IOException {
            BigInteger unscaled = value.unscaledValue();
            long longValue = unscaled.longValueExact();
            if (this.ref.indexType() != IndexType.NONE) {
                docBuilder.addField((IndexableField)new LongPoint(this.name, new long[]{longValue}));
            }
            if (this.ref.hasDocValues()) {
                docBuilder.addField((IndexableField)new SortedNumericDocValuesField(this.name, longValue));
            } else {
                if (docBuilder.maybeAddStoredField()) {
                    docBuilder.addField((IndexableField)new StoredField(this.name, longValue));
                }
                docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
            }
            docBuilder.translogWriter().writeValue(value);
        }
    }

    private static class LargeNumericIndexer
    extends BaseNumericIndexer {
        private final FieldType fieldType;
        private final int maxBytes;

        private LargeNumericIndexer(Reference ref, NumericType type) {
            super(ref);
            this.maxBytes = type.maxBytes();
            this.fieldType = new FieldType();
            this.fieldType.setDimensions(1, this.maxBytes);
            this.fieldType.freeze();
        }

        @Override
        public void indexValue(@NotNull BigDecimal value, IndexDocumentBuilder docBuilder) throws IOException {
            BigInteger unscaled = value.unscaledValue();
            byte[] bytes = new byte[this.maxBytes];
            NumericUtils.bigIntToSortableBytes((BigInteger)unscaled, (int)this.maxBytes, (byte[])bytes, (int)0);
            if (this.ref.indexType() != IndexType.NONE) {
                docBuilder.addField((IndexableField)new Field(this.name, bytes, (IndexableFieldType)this.fieldType));
            }
            if (this.ref.hasDocValues()) {
                docBuilder.addField((IndexableField)new SortedSetDocValuesField(this.name, new BytesRef(bytes)));
            } else {
                if (docBuilder.maybeAddStoredField()) {
                    docBuilder.addField((IndexableField)new StoredField(this.name, new BytesRef(bytes)));
                }
                docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
            }
            docBuilder.translogWriter().writeValue(value);
        }
    }

    private static abstract class BaseNumericIndexer
    implements ValueIndexer<BigDecimal> {
        protected final Reference ref;
        protected final String name;

        protected BaseNumericIndexer(Reference ref) {
            this.ref = ref;
            this.name = ref.storageIdent();
        }

        @Override
        public String storageIdentLeafName() {
            return this.ref.storageIdentLeafName();
        }
    }
}

