/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ParameterTypeSignature;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class RowType
extends DataType<Row>
implements Streamer<Row> {
    public static final int ID = 18;
    public static final String NAME = "record";
    public static final RowType EMPTY = new RowType(List.of());
    private final List<DataType<?>> fieldTypes;
    private final List<String> fieldNames;

    public RowType(List<DataType<?>> fieldTypes, List<String> fieldNames) {
        assert (fieldNames.isEmpty() || fieldNames.size() == fieldTypes.size()) : "fieldNames must either be empty or have the same length as fieldTypes";
        this.fieldTypes = fieldTypes;
        if (fieldNames.isEmpty() && !fieldTypes.isEmpty()) {
            ArrayList<CallSite> generatedFieldNames = new ArrayList<CallSite>(fieldTypes.size());
            for (int i = 0; i < fieldTypes.size(); ++i) {
                generatedFieldNames.add((CallSite)((Object)("col" + (i + 1))));
            }
            this.fieldNames = List.copyOf(generatedFieldNames);
        } else {
            this.fieldNames = List.copyOf(fieldNames);
        }
    }

    public RowType(List<DataType<?>> fieldTypes) {
        this(fieldTypes, List.of());
    }

    public RowType(StreamInput in) throws IOException {
        int numFields = in.readVInt();
        ArrayList fieldTypes = new ArrayList(numFields);
        ArrayList<String> fieldNames = new ArrayList<String>(numFields);
        for (int i = 0; i < numFields; ++i) {
            fieldTypes.add(DataTypes.fromStream(in));
            fieldNames.add(in.readString());
        }
        this.fieldTypes = List.copyOf(fieldTypes);
        this.fieldNames = List.copyOf(fieldNames);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.fieldTypes.size());
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            DataTypes.toStream(this.fieldTypes.get(i), out);
            out.writeString(this.fieldNames.get(i));
        }
    }

    public int numElements() {
        return this.fieldTypes.size();
    }

    public DataType<?> getFieldType(int position) {
        return this.fieldTypes.get(position);
    }

    public String getFieldName(int position) {
        return this.fieldNames.get(position);
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public List<DataType<?>> fieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public Row readValueFrom(StreamInput in) throws IOException {
        Object[] values = new Object[this.fieldTypes.size()];
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            values[i] = this.fieldTypes.get(i).streamer().readValueFrom(in);
        }
        return new RowN(values);
    }

    @Override
    public void writeValueTo(StreamOutput out, Row row) throws IOException {
        assert (row.numColumns() == this.fieldTypes.size()) : "Row that should be streamed must have the same number of columns as the rowType contains fieldTypes";
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            Streamer<?> streamer = this.fieldTypes.get(i).streamer();
            streamer.writeValueTo(out, row.get(i));
        }
    }

    @Override
    public int id() {
        return 18;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.TABLE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Streamer<Row> streamer() {
        return this;
    }

    @Override
    public Row implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return (Row)value;
    }

    @Override
    public Row sanitizeValue(Object value) {
        return (Row)value;
    }

    @Override
    public int compare(Row val1, Row val2) {
        assert (val1.numColumns() == val2.numColumns()) : "Rows to compare must have the same number of columns and types. val1=" + String.valueOf(val1) + ", val2=" + String.valueOf(val2);
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            DataType<?> dataType = this.fieldTypes.get(i);
            int cmp = dataType.compare(val1.get(i), val2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public TypeSignature getTypeSignature() {
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>(this.fieldNames.size());
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String fieldName = this.fieldNames.get(i);
            DataType<?> fieldType = this.fieldTypes.get(i);
            parameters.add(new ParameterTypeSignature(fieldName, fieldType.getTypeSignature()));
        }
        return new TypeSignature(NAME, parameters);
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        return this.fieldTypes;
    }

    @Override
    public long valueBytes(Row value) {
        if (value == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
        long size = 0L;
        for (int i = 0; i < value.numColumns(); ++i) {
            Object object = value.get(i);
            DataType<?> dataType = this.fieldTypes.get(i);
            size += dataType.valueBytes(object);
        }
        return size;
    }
}

