/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.jetbrains.annotations.Nullable;

public class RestoreSnapshotRequest
extends MasterNodeRequest<RestoreSnapshotRequest> {
    private String snapshot;
    private String repository;
    @Deprecated
    private String[] indices = Strings.EMPTY_ARRAY;
    @Deprecated
    private String[] templates = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.STRICT_EXPAND_OPEN;
    private String tableRenamePattern;
    private String tableRenameReplacement;
    private String schemaRenamePattern;
    private String schemaRenameReplacement;
    private boolean waitForCompletion;
    private boolean includeGlobalState = false;
    private boolean partial = false;
    private boolean includeAliases = true;
    private Settings settings = Settings.EMPTY;
    private Settings indexSettings = Settings.EMPTY;
    private String[] ignoreIndexSettings = Strings.EMPTY_ARRAY;
    private boolean includeIndices = true;
    private boolean includeCustomMetadata = false;
    private String[] customMetadataTypes = Strings.EMPTY_ARRAY;
    private boolean includeGlobalSettings = false;
    private String[] globalSettings = Strings.EMPTY_ARRAY;
    private List<TableOrPartition> tablesToRestore = List.of();

    public RestoreSnapshotRequest() {
    }

    public RestoreSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    public RestoreSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public RestoreSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public RestoreSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public RestoreSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[indices.size()]);
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public RestoreSnapshotRequest templates(String ... templates) {
        this.templates = templates;
        return this;
    }

    public String[] templates() {
        return this.templates;
    }

    public RestoreSnapshotRequest tablesToRestore(List<TableOrPartition> tablesToRestore) {
        this.tablesToRestore = tablesToRestore;
        return this;
    }

    public List<TableOrPartition> tablesToRestore() {
        return this.tablesToRestore;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public RestoreSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public RestoreSnapshotRequest tableRenamePattern(String tableRenamePattern) {
        this.tableRenamePattern = tableRenamePattern;
        return this;
    }

    public String tableRenamePattern() {
        return this.tableRenamePattern;
    }

    public RestoreSnapshotRequest tableRenameReplacement(String tableRenameReplacement) {
        this.tableRenameReplacement = tableRenameReplacement;
        return this;
    }

    public String tableRenameReplacement() {
        return this.tableRenameReplacement;
    }

    public RestoreSnapshotRequest schemaRenamePattern(String schemaRenamePattern) {
        this.schemaRenamePattern = schemaRenamePattern;
        return this;
    }

    public String schemaRenamePattern() {
        return this.schemaRenamePattern;
    }

    public RestoreSnapshotRequest schemaRenameReplacement(String schemaRenameReplacement) {
        this.schemaRenameReplacement = schemaRenameReplacement;
        return this;
    }

    public String schemaRenameReplacement() {
        return this.schemaRenameReplacement;
    }

    public RestoreSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public boolean partial() {
        return this.partial;
    }

    public RestoreSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public RestoreSnapshotRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public RestoreSnapshotRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public RestoreSnapshotRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public RestoreSnapshotRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = JsonXContent.builder();
            builder.map(source);
            this.settings(Strings.toString(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(String ... ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings;
        return this;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(List<String> ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings.toArray(new String[ignoreIndexSettings.size()]);
        return this;
    }

    public String[] ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    public RestoreSnapshotRequest includeAliases(boolean includeAliases) {
        this.includeAliases = includeAliases;
        return this;
    }

    public boolean includeAliases() {
        return this.includeAliases;
    }

    public RestoreSnapshotRequest indexSettings(Settings settings) {
        this.indexSettings = settings;
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Settings.Builder settings) {
        this.indexSettings = settings.build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(String source, XContentType xContentType) {
        this.indexSettings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Map<String, Object> source) {
        try {
            XContentBuilder builder = JsonXContent.builder();
            builder.map(source);
            this.indexSettings(Strings.toString(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
        return this;
    }

    public Settings indexSettings() {
        return this.indexSettings;
    }

    public RestoreSnapshotRequest includeIndices(boolean includeIndices) {
        this.includeIndices = includeIndices;
        return this;
    }

    public boolean includeIndices() {
        return this.includeIndices;
    }

    public RestoreSnapshotRequest includeCustomMetadata(boolean includeCustomMetadata) {
        this.includeCustomMetadata = includeCustomMetadata;
        return this;
    }

    public boolean includeCustomMetadata() {
        return this.includeCustomMetadata;
    }

    public RestoreSnapshotRequest customMetadataTypes(Set<String> types) {
        this.customMetadataTypes = types.toArray(new String[0]);
        return this;
    }

    public String[] customMetadataTypes() {
        return this.customMetadataTypes;
    }

    public RestoreSnapshotRequest includeGlobalSettings(boolean includeGlobalSettings) {
        this.includeGlobalSettings = includeGlobalSettings;
        return this;
    }

    public boolean includeGlobalSettings() {
        return this.includeGlobalSettings;
    }

    public RestoreSnapshotRequest globalSettings(List<String> globalSettings) {
        this.globalSettings = globalSettings.toArray(new String[0]);
        return this;
    }

    public String[] globalSettings() {
        return this.globalSettings;
    }

    public RestoreSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getVersion().before(Version.V_5_6_0)) {
            this.tableRenamePattern = in.readOptionalString();
            this.tableRenameReplacement = in.readOptionalString();
        } else {
            this.tableRenamePattern = in.readString();
            this.tableRenameReplacement = in.readString();
        }
        this.waitForCompletion = in.readBoolean();
        if (in.getVersion().before(Version.V_4_5_0)) {
            in.readBoolean();
        }
        this.partial = in.readBoolean();
        this.includeAliases = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        this.indexSettings = Settings.readSettingsFromStream(in);
        this.ignoreIndexSettings = in.readStringArray();
        this.templates = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_4_5_0)) {
            this.includeIndices = in.readBoolean();
            this.includeCustomMetadata = in.readBoolean();
            this.customMetadataTypes = in.readStringArray();
            this.includeGlobalSettings = in.readBoolean();
            this.globalSettings = in.readStringArray();
        }
        if (in.getVersion().onOrAfter(Version.V_5_6_0)) {
            this.tablesToRestore = in.readList(TableOrPartition::new);
            this.schemaRenamePattern = in.readString();
            this.schemaRenameReplacement = in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getVersion().before(Version.V_5_6_0)) {
            out.writeOptionalString(this.tableRenamePattern);
            out.writeOptionalString(this.tableRenameReplacement);
        } else {
            out.writeString(this.tableRenamePattern);
            out.writeString(this.tableRenameReplacement);
        }
        out.writeBoolean(this.waitForCompletion);
        if (out.getVersion().before(Version.V_4_5_0)) {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.partial);
        out.writeBoolean(this.includeAliases);
        Settings.writeSettingsToStream(out, this.settings);
        Settings.writeSettingsToStream(out, this.indexSettings);
        out.writeStringArray(this.ignoreIndexSettings);
        out.writeStringArray(this.templates);
        if (out.getVersion().onOrAfter(Version.V_4_5_0)) {
            out.writeBoolean(this.includeIndices);
            out.writeBoolean(this.includeCustomMetadata);
            out.writeStringArray(this.customMetadataTypes);
            out.writeBoolean(this.includeGlobalSettings);
            out.writeStringArray(this.globalSettings);
        }
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeCollection(this.tablesToRestore);
            out.writeString(this.schemaRenamePattern);
            out.writeString(this.schemaRenameReplacement);
        }
    }

    @Override
    public String getDescription() {
        return "snapshot [" + this.repository + ":" + this.snapshot + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotRequest that = (RestoreSnapshotRequest)o;
        return this.waitForCompletion == that.waitForCompletion && this.includeGlobalState == that.includeGlobalState && this.partial == that.partial && this.includeAliases == that.includeAliases && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.repository, that.repository) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.tableRenamePattern, that.tableRenamePattern) && Objects.equals(this.tableRenameReplacement, that.tableRenameReplacement) && Objects.equals(this.schemaRenamePattern, that.schemaRenamePattern) && Objects.equals(this.schemaRenameReplacement, that.schemaRenameReplacement) && Objects.equals(this.settings, that.settings) && Objects.equals(this.indexSettings, that.indexSettings) && Arrays.equals(this.ignoreIndexSettings, that.ignoreIndexSettings) && this.includeIndices == that.includeIndices && this.includeCustomMetadata == that.includeCustomMetadata && Arrays.equals(this.customMetadataTypes, that.customMetadataTypes) && this.includeGlobalSettings == that.includeGlobalSettings && Arrays.equals(this.globalSettings, that.globalSettings);
    }

    public int hashCode() {
        int result = Objects.hash(this.snapshot, this.repository, this.indicesOptions, this.tableRenamePattern, this.tableRenameReplacement, this.waitForCompletion, this.includeGlobalState, this.partial, this.includeAliases, this.settings, this.indexSettings, this.includeIndices, this.includeCustomMetadata, this.includeGlobalSettings, this.schemaRenamePattern, this.schemaRenameReplacement);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.ignoreIndexSettings);
        result = 31 * result + Arrays.hashCode(this.customMetadataTypes);
        result = 31 * result + Arrays.hashCode(this.globalSettings);
        return result;
    }

    public record TableOrPartition(RelationName table, @Nullable String partitionIdent) implements Writeable
    {
        public TableOrPartition(StreamInput in) throws IOException {
            this(new RelationName(in), in.readOptionalString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.table.writeTo(out);
            out.writeOptionalString(this.partitionIdent);
        }
    }
}

