/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.tasks;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public class PendingClusterTasksResponse
extends TransportResponse
implements Iterable<PendingClusterTask> {
    private final List<PendingClusterTask> pendingTasks;

    PendingClusterTasksResponse(List<PendingClusterTask> pendingTasks) {
        this.pendingTasks = pendingTasks;
    }

    public List<PendingClusterTask> pendingTasks() {
        return this.pendingTasks;
    }

    @Override
    public Iterator<PendingClusterTask> iterator() {
        return this.pendingTasks.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tasks: (").append(this.pendingTasks.size()).append("):\n");
        for (PendingClusterTask pendingClusterTask : this) {
            sb.append(pendingClusterTask.getInsertOrder()).append("/").append((Object)pendingClusterTask.getPriority()).append("/").append(pendingClusterTask.getSource()).append("/").append(pendingClusterTask.getTimeInQueue()).append("\n");
        }
        return sb.toString();
    }

    public PendingClusterTasksResponse(StreamInput in) throws IOException {
        this.pendingTasks = in.readList(PendingClusterTask::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.pendingTasks);
    }
}

