/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class CreateIndexRequest
extends AcknowledgedRequest<CreateIndexRequest>
implements IndicesRequest {
    private String cause = "";
    private String index;
    private Settings settings = Settings.EMPTY;
    private final Set<Alias> aliases = new HashSet<Alias>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexRequest(String index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
    }

    public String index() {
        return this.index;
    }

    public Settings settings() {
        return this.settings;
    }

    public String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public CreateIndexRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexRequest(StreamInput in) throws IOException {
        super(in);
        int i;
        this.cause = in.readString();
        this.index = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        Version version = in.getVersion();
        if (!version.onOrAfter(Version.V_5_8_0)) {
            if (version.onOrAfter(Version.V_5_0_0)) {
                in.readOptionalString();
            } else {
                int size = in.readVInt();
                for (i = 0; i < size; ++i) {
                    in.readString();
                    in.readString();
                }
            }
        }
        int aliasesSize = in.readVInt();
        for (i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        if (version.before(Version.V_4_3_0)) {
            in.readBoolean();
        }
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.index);
        Settings.writeSettingsToStream(out, this.settings);
        Version version = out.getVersion();
        if (!version.onOrAfter(Version.V_5_8_0)) {
            if (version.onOrAfter(Version.V_5_0_0)) {
                out.writeOptionalString(null);
            } else {
                out.writeVInt(0);
            }
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        if (version.before(Version.V_4_3_0)) {
            out.writeBoolean(true);
        }
        this.waitForActiveShards.writeTo(out);
    }
}

