/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;

public class IndexShardStats
implements Iterable<ShardStats> {
    private final List<ShardStats> shards;
    private CommonStats primary = null;

    public IndexShardStats(List<ShardStats> shards) {
        this.shards = shards;
    }

    @Override
    public Iterator<ShardStats> iterator() {
        return this.shards.iterator();
    }

    public CommonStats getPrimary() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.getShardRouting().primary()) continue;
            stats.add(shard.getStats());
        }
        this.primary = stats;
        return stats;
    }
}

