/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.ShardPath;
import org.jetbrains.annotations.Nullable;

public class ShardStats
implements Writeable {
    private final ShardRouting shardRouting;
    private final CommonStats commonStats;
    @Nullable
    private final CommitStats commitStats;
    @Nullable
    private final SeqNoStats seqNoStats;
    @Nullable
    private RetentionLeaseStats retentionLeaseStats;
    private final String dataPath;
    private final String statePath;
    private final boolean isCustomDataPath;

    public RetentionLeaseStats getRetentionLeaseStats() {
        return this.retentionLeaseStats;
    }

    public ShardStats(ShardRouting routing, ShardPath shardPath, CommonStats commonStats, CommitStats commitStats, SeqNoStats seqNoStats, RetentionLeaseStats retentionLeaseStats) {
        this.shardRouting = routing;
        this.dataPath = shardPath.getRootDataPath().toString();
        this.statePath = shardPath.getRootStatePath().toString();
        this.isCustomDataPath = shardPath.isCustomDataPath();
        this.commitStats = commitStats;
        this.commonStats = commonStats;
        this.seqNoStats = seqNoStats;
        this.retentionLeaseStats = retentionLeaseStats;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.commonStats;
    }

    @Nullable
    public CommitStats getCommitStats() {
        return this.commitStats;
    }

    @Nullable
    public SeqNoStats getSeqNoStats() {
        return this.seqNoStats;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    public String getStatePath() {
        return this.statePath;
    }

    public ShardStats(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.commonStats = new CommonStats(in);
        this.commitStats = in.readOptionalWriteable(CommitStats::new);
        this.statePath = in.readString();
        this.dataPath = in.readString();
        this.isCustomDataPath = in.readBoolean();
        this.seqNoStats = in.readOptionalWriteable(SeqNoStats::new);
        if (in.getVersion().onOrAfter(Version.V_4_3_0)) {
            this.retentionLeaseStats = in.readOptionalWriteable(RetentionLeaseStats::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.commonStats.writeTo(out);
        out.writeOptionalWriteable(this.commitStats);
        out.writeString(this.statePath);
        out.writeString(this.dataPath);
        out.writeBoolean(this.isCustomDataPath);
        out.writeOptionalWriteable(this.seqNoStats);
        if (out.getVersion().onOrAfter(Version.V_4_3_0)) {
            out.writeOptionalWriteable(this.retentionLeaseStats);
        }
    }
}

