/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import io.crate.common.unit.TimeValue;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.node.NodeClosedException;

public class ActiveShardsObserver {
    private static final Logger LOGGER = LogManager.getLogger(ActiveShardsObserver.class);
    private final ClusterService clusterService;

    public ActiveShardsObserver(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void waitForActiveShards(final String[] indexNames, ActiveShardCount activeShardCount, TimeValue timeout, final Consumer<Boolean> onResult, final Consumer<Exception> onFailure) {
        if (activeShardCount == ActiveShardCount.NONE) {
            onResult.accept(true);
            return;
        }
        ClusterState state = this.clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService.getClusterApplierService(), null, LOGGER);
        if (activeShardCount.enoughShardsActive(state, indexNames)) {
            onResult.accept(true);
        } else {
            Predicate<ClusterState> shardsAllocatedPredicate = newState -> activeShardCount.enoughShardsActive((ClusterState)newState, indexNames);
            ClusterStateObserver.Listener observerListener = new ClusterStateObserver.Listener(){
                final /* synthetic */ ActiveShardsObserver this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onNewClusterState(ClusterState state) {
                    onResult.accept(true);
                }

                @Override
                public void onClusterServiceClose() {
                    LOGGER.debug("[{}] cluster service closed while waiting for enough shards to be started.", (Object)Arrays.toString(indexNames));
                    onFailure.accept(new NodeClosedException(this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    onResult.accept(false);
                }
            };
            observer.waitForNextChange(observerListener, shardsAllocatedPredicate, timeout);
        }
    }
}

