/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndicesOptions {
    public static final IndicesOptions STRICT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.FORBID_CLOSED_INDICES), EnumSet.noneOf(WildcardStates.class));
    private final EnumSet<Option> options;
    private final EnumSet<WildcardStates> expandWildcards;

    public IndicesOptions(EnumSet<Option> options, EnumSet<WildcardStates> expandWildcards) {
        this.options = options;
        this.expandWildcards = expandWildcards;
    }

    private IndicesOptions(Collection<Option> options, Collection<WildcardStates> expandWildcards) {
        this(options.isEmpty() ? Option.NONE : EnumSet.copyOf(options), expandWildcards.isEmpty() ? WildcardStates.NONE : EnumSet.copyOf(expandWildcards));
    }

    public boolean ignoreUnavailable() {
        return this.options.contains((Object)Option.IGNORE_UNAVAILABLE);
    }

    public boolean allowNoIndices() {
        return this.options.contains((Object)Option.ALLOW_NO_INDICES);
    }

    public boolean expandWildcardsOpen() {
        return this.expandWildcards.contains((Object)WildcardStates.OPEN);
    }

    public boolean expandWildcardsClosed() {
        return this.expandWildcards.contains((Object)WildcardStates.CLOSED);
    }

    public boolean forbidClosedIndices() {
        return this.options.contains((Object)Option.FORBID_CLOSED_INDICES);
    }

    public void writeIndicesOptions(StreamOutput out) throws IOException {
        out.writeEnumSet(this.options);
        out.writeEnumSet(this.expandWildcards);
    }

    public static IndicesOptions readIndicesOptions(StreamInput in) throws IOException {
        return new IndicesOptions(in.readEnumSet(Option.class), in.readEnumSet(WildcardStates.class));
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, IndicesOptions defaultOptions) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, defaultOptions.forbidClosedIndices());
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean forbidClosedIndices) {
        HashSet<Option> opts = new HashSet<Option>();
        HashSet<WildcardStates> wildcards = new HashSet<WildcardStates>();
        if (ignoreUnavailable) {
            opts.add(Option.IGNORE_UNAVAILABLE);
        }
        if (allowNoIndices) {
            opts.add(Option.ALLOW_NO_INDICES);
        }
        if (expandToOpenIndices) {
            wildcards.add(WildcardStates.OPEN);
        }
        if (expandToClosedIndices) {
            wildcards.add(WildcardStates.CLOSED);
        }
        if (forbidClosedIndices) {
            opts.add(Option.FORBID_CLOSED_INDICES);
        }
        return new IndicesOptions(opts, wildcards);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndicesOptions other = (IndicesOptions)obj;
        return this.options.equals(other.options) && this.expandWildcards.equals(other.expandWildcards);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        return 31 * result + this.expandWildcards.hashCode();
    }

    public String toString() {
        return "IndicesOptions[ignore_unavailable=" + this.ignoreUnavailable() + ", allow_no_indices=" + this.allowNoIndices() + ", expand_wildcards_open=" + this.expandWildcardsOpen() + ", expand_wildcards_closed=" + this.expandWildcardsClosed() + ", forbid_closed_indices=" + this.forbidClosedIndices() + "]";
    }

    public static enum Option {
        IGNORE_UNAVAILABLE,
        ALLOW_NO_INDICES,
        FORBID_CLOSED_INDICES;

        public static final EnumSet<Option> NONE;

        static {
            NONE = EnumSet.noneOf(Option.class);
        }
    }

    public static enum WildcardStates {
        OPEN,
        CLOSED;

        public static final EnumSet<WildcardStates> NONE;

        static {
            NONE = EnumSet.noneOf(WildcardStates.class);
        }
    }
}

