/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.exceptions.SQLExceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastReplicationAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardRequest extends ReplicationRequest<ShardRequest>, ShardResponse extends ReplicationResponse>
extends HandledTransportAction<Request, Response> {
    private final ActionType<ShardResponse> replicatedBroadcastShardAction;
    private final ClusterService clusterService;
    private final NodeClient client;

    public TransportBroadcastReplicationAction(String name, Writeable.Reader<Request> reader, ClusterService clusterService, TransportService transportService, NodeClient client, ActionType<ShardResponse> replicatedBroadcastShardAction) {
        super(name, transportService, reader);
        this.client = client;
        this.replicatedBroadcastShardAction = replicatedBroadcastShardAction;
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(Request request, final ActionListener<Response> listener) {
        final ClusterState clusterState = this.clusterService.state();
        List<ShardId> shards = this.shards(request, clusterState);
        final CopyOnWriteArrayList shardsResponses = new CopyOnWriteArrayList();
        if (shards.size() == 0) {
            this.finishAndNotifyListener(listener, shardsResponses);
        }
        final CountDown responsesCountDown = new CountDown(shards.size());
        for (final ShardId shardId : shards) {
            ActionListener shardActionListener = new ActionListener<ShardResponse>(){
                final /* synthetic */ TransportBroadcastReplicationAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onResponse(ShardResponse shardResponse) {
                    shardsResponses.add(shardResponse);
                    this.this$0.logger.trace("{}: got response from {}", (Object)this.this$0.actionName, (Object)shardId);
                    if (responsesCountDown.countDown()) {
                        this.this$0.finishAndNotifyListener(listener, shardsResponses);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    Object[] failures;
                    this.this$0.logger.trace("{}: got failure from {}", (Object)this.this$0.actionName, (Object)shardId);
                    int totalNumCopies = clusterState.metadata().getIndexSafe(shardId.getIndex()).getNumberOfReplicas() + 1;
                    Object shardResponse = this.this$0.newShardResponse();
                    if (TransportActions.isShardNotAvailableException(e)) {
                        failures = new ReplicationResponse.ShardInfo.Failure[]{};
                    } else {
                        ReplicationResponse.ShardInfo.Failure failure = new ReplicationResponse.ShardInfo.Failure(shardId, null, e, SQLExceptions.status(e), true);
                        failures = new ReplicationResponse.ShardInfo.Failure[totalNumCopies];
                        Arrays.fill(failures, failure);
                    }
                    ((ReplicationResponse)shardResponse).setShardInfo(new ReplicationResponse.ShardInfo(totalNumCopies, 0, (ReplicationResponse.ShardInfo.Failure[])failures));
                    shardsResponses.add(shardResponse);
                    if (responsesCountDown.countDown()) {
                        this.this$0.finishAndNotifyListener(listener, shardsResponses);
                    }
                }
            };
            this.shardExecute(request, shardId, shardActionListener);
        }
    }

    protected void shardExecute(Request request, ShardId shardId, ActionListener<ShardResponse> shardActionListener) {
        ShardRequest shardRequest = this.newShardRequest(request, shardId);
        this.client.execute(this.replicatedBroadcastShardAction, shardRequest).whenComplete(shardActionListener);
    }

    protected List<ShardId> shards(Request request, ClusterState clusterState) {
        String[] concreteIndices;
        ArrayList<ShardId> shardIds = new ArrayList<ShardId>();
        for (String index : concreteIndices = IndexNameExpressionResolver.concreteIndexNames(clusterState, request)) {
            IndexMetadata indexMetadata = clusterState.metadata().indices().get(index);
            if (indexMetadata == null) continue;
            IndexRoutingTable indexRoutingTable = clusterState.routingTable().indicesRouting().get(index);
            for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : indexRoutingTable.getShards()) {
                shardIds.add(((IndexShardRoutingTable)intObjectCursor.value).shardId());
            }
        }
        return shardIds;
    }

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardRequest newShardRequest(Request var1, ShardId var2);

    private void finishAndNotifyListener(ActionListener<Response> listener, CopyOnWriteArrayList<ShardResponse> shardsResponses) {
        this.logger.trace("{}: got all shard responses", (Object)this.actionName);
        int successfulShards = 0;
        int failedShards = 0;
        int totalNumCopies = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.size(); ++i) {
            ReplicationResponse shardResponse = (ReplicationResponse)shardsResponses.get(i);
            if (shardResponse == null) continue;
            failedShards += shardResponse.getShardInfo().getFailed();
            successfulShards += shardResponse.getShardInfo().getSuccessful();
            totalNumCopies += shardResponse.getShardInfo().getTotal();
            if (shardFailures == null) {
                shardFailures = new ArrayList<DefaultShardOperationFailedException>();
            }
            for (ReplicationResponse.ShardInfo.Failure failure : shardResponse.getShardInfo().getFailures()) {
                shardFailures.add(new DefaultShardOperationFailedException(new BroadcastShardOperationFailedException(failure.fullShardId(), failure.getCause())));
            }
        }
        listener.onResponse(this.newResponse(successfulShards, failedShards, totalNumCopies, shardFailures));
    }

    protected abstract Response newResponse(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);
}

