/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Assertions;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.PendingReplicationActions;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ReplicationGroup;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardNotInPrimaryModeException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public abstract class TransportReplicationAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportAction<Request, Response> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    public static final Setting<TimeValue> REPLICATION_RETRY_TIMEOUT = Setting.timeSetting("indices.replication.retry_timeout", TimeValue.timeValueSeconds((long)60L), Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<TimeValue> REPLICATION_INITIAL_RETRY_BACKOFF_BOUND = Setting.timeSetting("indices.replication.initial_retry_backoff_bound", TimeValue.timeValueMillis((long)50L), TimeValue.timeValueMillis((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final ShardStateAction shardStateAction;
    protected final IndicesService indicesService;
    protected final TransportRequestOptions transportOptions;
    protected final String executor;
    protected final String transportReplicaAction;
    protected final String transportPrimaryAction;
    private final boolean syncGlobalCheckpointAfterOperation;
    private volatile TimeValue initialRetryBackoffBound;
    private volatile TimeValue retryTimeout;
    protected final boolean forceExecutionOnPrimary;

    protected TransportReplicationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, Writeable.Reader<Request> reader, Writeable.Reader<ReplicaRequest> replicaReader, String executor) {
        this(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, reader, replicaReader, executor, false, false);
    }

    protected TransportReplicationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, Writeable.Reader<Request> reader, Writeable.Reader<ReplicaRequest> replicaReader, String executor, boolean syncGlobalCheckpointAfterOperation, boolean forceExecutionOnPrimary) {
        super(actionName);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.executor = executor;
        this.transportPrimaryAction = actionName + "[p]";
        this.transportReplicaAction = actionName + "[r]";
        this.initialRetryBackoffBound = REPLICATION_INITIAL_RETRY_BACKOFF_BOUND.get(settings);
        this.retryTimeout = REPLICATION_RETRY_TIMEOUT.get(settings);
        this.forceExecutionOnPrimary = forceExecutionOnPrimary;
        transportService.registerRequestHandler(actionName, "same", reader, this::handleOperationRequest);
        transportService.registerRequestHandler(this.transportPrimaryAction, executor, forceExecutionOnPrimary, true, in -> new ConcreteShardRequest(in, reader), this::handlePrimaryRequest);
        transportService.registerRequestHandler(this.transportReplicaAction, executor, true, true, in -> new ConcreteReplicaRequest(in, replicaReader), this::handleReplicaRequest);
        this.transportOptions = this.transportOptions();
        this.syncGlobalCheckpointAfterOperation = syncGlobalCheckpointAfterOperation;
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(REPLICATION_INITIAL_RETRY_BACKOFF_BOUND, v -> {
            this.initialRetryBackoffBound = v;
        });
        clusterSettings.addSettingsUpdateConsumer(REPLICATION_RETRY_TIMEOUT, v -> {
            this.retryTimeout = v;
        });
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new ReroutePhase(this, request, listener).run();
    }

    protected ReplicationOperation.Replicas<ReplicaRequest> newReplicasProxy() {
        return new ReplicasProxy();
    }

    protected abstract Response newResponseInstance(StreamInput var1) throws IOException;

    protected void resolveRequest(IndexMetadata indexMetadata, Request request) {
        if (((ReplicationRequest)request).waitForActiveShards() == ActiveShardCount.DEFAULT) {
            ((ReplicationRequest)request).waitForActiveShards(indexMetadata.getWaitForActiveShards());
        }
    }

    protected abstract void shardOperationOnPrimary(Request var1, IndexShard var2, ActionListener<PrimaryResult<ReplicaRequest, Response>> var3);

    protected abstract ReplicaResult shardOperationOnReplica(ReplicaRequest var1, IndexShard var2) throws Exception;

    @Nullable
    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    @Nullable
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    private ClusterBlockException blockExceptions(ClusterState state, String indexName) {
        ClusterBlockException blockException;
        ClusterBlockException blockException2;
        ClusterBlockLevel globalBlockLevel = this.globalBlockLevel();
        if (globalBlockLevel != null && (blockException2 = state.blocks().globalBlockedException(globalBlockLevel)) != null) {
            return blockException2;
        }
        ClusterBlockLevel indexBlockLevel = this.indexBlockLevel();
        if (indexBlockLevel != null && (blockException = state.blocks().indexBlockedException(indexBlockLevel, indexName)) != null) {
            return blockException;
        }
        return null;
    }

    protected boolean retryPrimaryException(Throwable e) {
        return e.getClass() == ReplicationOperation.RetryOnPrimaryException.class || TransportActions.isShardNotAvailableException(e) || this.isRetryableClusterBlockException(e);
    }

    boolean isRetryableClusterBlockException(Throwable e) {
        if (e instanceof ClusterBlockException) {
            return ((ClusterBlockException)e).retryable();
        }
        return false;
    }

    protected void handleOperationRequest(Request request, TransportChannel channel) {
        this.execute(request).whenComplete((BiConsumer)new ChannelActionListener(channel, this.actionName, request));
    }

    protected void handlePrimaryRequest(ConcreteShardRequest<Request> request, TransportChannel channel) {
        new AsyncPrimaryAction(request, new ChannelActionListener(channel, this.transportPrimaryAction, request)).run();
    }

    protected void adaptResponse(Response response, IndexShard indexShard) {
    }

    protected void handleReplicaRequest(ConcreteReplicaRequest<ReplicaRequest> replicaRequest, TransportChannel channel) {
        new AsyncReplicaAction(replicaRequest, new ChannelActionListener(channel, this.transportReplicaAction, replicaRequest)).run();
    }

    private IndexShard getIndexShard(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getShard(shardId.id());
    }

    protected void acquirePrimaryOperationPermit(IndexShard primary, Request request, ActionListener<Releasable> onAcquired) {
        primary.acquirePrimaryOperationPermit(onAcquired, this.executor, request, this.forceExecutionOnPrimary);
    }

    protected void acquireReplicaOperationPermit(IndexShard replica, ReplicaRequest request, ActionListener<Releasable> onAcquired, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes) {
        replica.acquireReplicaOperationPermit(primaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, onAcquired, this.executor, request);
    }

    static final class ReroutePhase
    extends AbstractRunnable {
        private final ActionListener<Response> listener;
        private final Request request;
        private final ClusterStateObserver observer;
        private final AtomicBoolean finished = new AtomicBoolean();
        final /* synthetic */ TransportReplicationAction this$0;

        ReroutePhase(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
            this.observer = new ClusterStateObserver(this$0.clusterService, ((ReplicationRequest)request).timeout(), this$0.logger);
        }

        @Override
        public void onFailure(Exception e) {
            this.finishWithUnexpectedFailure(e);
        }

        @Override
        protected void doRun() {
            ClusterState state = this.observer.setAndGetObservedState();
            ClusterBlockException blockException = this.this$0.blockExceptions(state, ((ReplicationRequest)this.request).shardId().getIndexName());
            if (blockException != null) {
                if (blockException.retryable()) {
                    this.this$0.logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                    this.retry(blockException);
                } else {
                    this.finishAsFailed(blockException);
                }
            } else {
                IndexMetadata indexMetadata = state.metadata().index(((ReplicationRequest)this.request).shardId().getIndex());
                if (indexMetadata == null) {
                    if (state.version() < ((ReplicationRequest)this.request).routedBasedOnClusterVersion()) {
                        this.this$0.logger.trace("failed to find index [{}] for request [{}] despite sender thinking it would be here. Local cluster state version [{}]] is older than on sending node (version [{}]), scheduling a retry...", (Object)((ReplicationRequest)this.request).shardId().getIndex(), this.request, (Object)state.version(), (Object)((ReplicationRequest)this.request).routedBasedOnClusterVersion());
                        this.retry(new IndexNotFoundException("failed to find index as current cluster state with version [" + state.version() + "] is stale (expected at least [" + ((ReplicationRequest)this.request).routedBasedOnClusterVersion() + "]", ((ReplicationRequest)this.request).shardId().getIndexName()));
                        return;
                    }
                    this.finishAsFailed(new IndexNotFoundException(((ReplicationRequest)this.request).shardId().getIndex()));
                    return;
                }
                if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    this.finishAsFailed(new IndexClosedException(indexMetadata.getIndex()));
                    return;
                }
                if (((ReplicationRequest)this.request).waitForActiveShards() == ActiveShardCount.DEFAULT) {
                    ((ReplicationRequest)this.request).waitForActiveShards(indexMetadata.getWaitForActiveShards());
                }
                assert (((ReplicationRequest)this.request).waitForActiveShards() != ActiveShardCount.DEFAULT) : "request waitForActiveShards must be set in resolveRequest";
                ShardRouting primary = state.routingTable().shardRoutingTable(((ReplicationRequest)this.request).shardId()).primaryShard();
                if (primary == null || !primary.active()) {
                    this.this$0.logger.trace("primary shard [{}] is not yet active, scheduling a retry: action [{}], request [{}], cluster state version [{}]", (Object)((ReplicationRequest)this.request).shardId(), (Object)this.this$0.actionName, this.request, (Object)state.version());
                    this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "primary shard is not active");
                    return;
                }
                if (!state.nodes().nodeExists(primary.currentNodeId())) {
                    this.this$0.logger.trace("primary shard [{}] is assigned to an unknown node [{}], scheduling a retry: action [{}], request [{}], cluster state version [{}]", (Object)((ReplicationRequest)this.request).shardId(), (Object)primary.currentNodeId(), (Object)this.this$0.actionName, this.request, (Object)state.version());
                    this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "primary shard isn't assigned to a known node.");
                    return;
                }
                DiscoveryNode node = state.nodes().get(primary.currentNodeId());
                if (primary.currentNodeId().equals(state.nodes().getLocalNodeId())) {
                    this.performLocalAction(state, primary, node, indexMetadata);
                } else {
                    this.performRemoteAction(state, primary, node);
                }
            }
        }

        private void performLocalAction(ClusterState state, ShardRouting primary, DiscoveryNode node, IndexMetadata indexMetadata) {
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("send action [{}] to local primary [{}] for request [{}] with cluster state version [{}] to [{}] ", (Object)this.this$0.transportPrimaryAction, (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)primary.currentNodeId());
            }
            this.performAction(node, this.this$0.transportPrimaryAction, true, new ConcreteShardRequest(this.request, primary.allocationId().getId(), indexMetadata.primaryTerm(primary.id())));
        }

        private void performRemoteAction(ClusterState state, ShardRouting primary, DiscoveryNode node) {
            if (state.version() < ((ReplicationRequest)this.request).routedBasedOnClusterVersion()) {
                this.this$0.logger.trace("failed to find primary [{}] for request [{}] despite sender thinking it would be here. Local cluster state version [{}]] is older than on sending node (version [{}]), scheduling a retry...", (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)((ReplicationRequest)this.request).routedBasedOnClusterVersion());
                this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "failed to find primary as current cluster state with version [" + state.version() + "] is stale (expected at least [" + ((ReplicationRequest)this.request).routedBasedOnClusterVersion() + "]");
                return;
            }
            ((ReplicationRequest)this.request).routedBasedOnClusterVersion(state.version());
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("send action [{}] on primary [{}] for request [{}] with cluster state version [{}] to [{}]", (Object)this.this$0.actionName, (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)primary.currentNodeId());
            }
            this.performAction(node, this.this$0.actionName, false, (TransportRequest)this.request);
        }

        private void performAction(final DiscoveryNode node, String action, final boolean isPrimaryAction, final TransportRequest requestToPerform) {
            this.this$0.transportService.sendRequest(node, action, requestToPerform, this.this$0.transportOptions, new TransportResponseHandler<Response>(){
                final /* synthetic */ ReroutePhase this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public Response read(StreamInput in) throws IOException {
                    return this.this$1.this$0.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(Response response) {
                    this.this$1.finishOnSuccess(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    try {
                        Throwable cause = exp.unwrapCause();
                        if (cause instanceof ConnectTransportException || cause instanceof NodeClosedException || isPrimaryAction && this.this$1.this$0.retryPrimaryException(cause)) {
                            this.this$1.this$0.logger.trace(() -> new ParameterizedMessage("received an error from node [{}] for request [{}], scheduling a retry", (Object)node.getId(), (Object)requestToPerform), (Throwable)exp);
                            this.this$1.retry(exp);
                        } else {
                            this.this$1.finishAsFailed(exp);
                        }
                    }
                    catch (Exception e) {
                        e.addSuppressed(exp);
                        this.this$1.finishWithUnexpectedFailure(e);
                    }
                }
            });
        }

        void retry(Exception failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.finishAsFailed(failure);
                return;
            }
            ((ReplicationRequest)this.request).onRetry();
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    ReroutePhase.this.run();
                }

                @Override
                public void onClusterServiceClose() {
                    ReroutePhase.this.finishAsFailed(new NodeClosedException(ReroutePhase.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    ReroutePhase.this.run();
                }
            });
        }

        void finishAsFailed(Exception failure) {
            if (this.finished.compareAndSet(false, true)) {
                this.this$0.logger.trace(() -> new ParameterizedMessage("operation failed. action [{}], request [{}]", (Object)this.this$0.actionName, this.request), (Throwable)failure);
                this.listener.onFailure(failure);
            } else assert (false) : new AssertionError("finishAsFailed called but operation is already finished", failure);
        }

        void finishWithUnexpectedFailure(Exception failure) {
            this.this$0.logger.warn(() -> new ParameterizedMessage("unexpected error during the primary phase for action [{}], request [{}]", (Object)this.this$0.actionName, this.request), (Throwable)failure);
            if (this.finished.compareAndSet(false, true)) {
                this.listener.onFailure(failure);
            } else assert (false) : new AssertionError("finishWithUnexpectedFailure called but operation is already finished", failure);
        }

        void finishOnSuccess(Response response) {
            if (this.finished.compareAndSet(false, true)) {
                if (this.this$0.logger.isTraceEnabled()) {
                    this.this$0.logger.trace("operation succeeded. action [{}],request [{}]", (Object)this.this$0.actionName, this.request);
                }
                this.listener.onResponse(response);
            } else assert (false) : "finishOnSuccess called but operation is already finished";
        }

        void retryBecauseUnavailable(ShardId shardId, String message) {
            this.retry(new UnavailableShardsException(shardId, "{} Timeout: [{}], request: [{}]", message, ((ReplicationRequest)this.request).timeout(), this.request));
        }
    }

    protected class ReplicasProxy
    implements ReplicationOperation.Replicas<ReplicaRequest> {
        protected ReplicasProxy() {
        }

        @Override
        public void performOn(ShardRouting replica, ReplicaRequest request, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
            String nodeId = replica.currentNodeId();
            DiscoveryNode node = TransportReplicationAction.this.clusterService.state().nodes().get(nodeId);
            if (node == null) {
                listener.onFailure(new NoNodeAvailableException("unknown node [" + nodeId + "]"));
                return;
            }
            ConcreteReplicaRequest replicaRequest = new ConcreteReplicaRequest(request, replica.allocationId().getId(), primaryTerm, globalCheckpoint, maxSeqNoOfUpdatesOrDeletes);
            ActionListenerResponseHandler<ReplicaResponse> handler = new ActionListenerResponseHandler<ReplicaResponse>(listener, ReplicaResponse::new);
            TransportReplicationAction.this.transportService.sendRequest(node, TransportReplicationAction.this.transportReplicaAction, replicaRequest, TransportReplicationAction.this.transportOptions, handler);
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            listener.onResponse(null);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            listener.onResponse(null);
        }
    }

    class AsyncPrimaryAction
    extends AbstractRunnable {
        private final ActionListener<Response> onCompletionListener;
        private final ConcreteShardRequest<Request> primaryRequest;

        AsyncPrimaryAction(ConcreteShardRequest<Request> primaryRequest, ActionListener<Response> onCompletionListener) {
            this.primaryRequest = primaryRequest;
            this.onCompletionListener = onCompletionListener;
        }

        @Override
        protected void doRun() throws Exception {
            ShardId shardId = ((ReplicationRequest)this.primaryRequest.getRequest()).shardId();
            IndexShard indexShard = TransportReplicationAction.this.getIndexShard(shardId);
            ShardRouting shardRouting = indexShard.routingEntry();
            if (!shardRouting.primary()) {
                throw new ReplicationOperation.RetryOnPrimaryException(shardId, "actual shard is not a primary " + String.valueOf(shardRouting));
            }
            String actualAllocationId = shardRouting.allocationId().getId();
            if (!actualAllocationId.equals(this.primaryRequest.getTargetAllocationID())) {
                throw new ShardNotFoundException(shardId, "expected allocation id [{}] but found [{}]", this.primaryRequest.getTargetAllocationID(), actualAllocationId);
            }
            long actualTerm = indexShard.getPendingPrimaryTerm();
            if (actualTerm != this.primaryRequest.getPrimaryTerm()) {
                throw new ShardNotFoundException(shardId, "expected allocation id [{}] with term [{}] but found [{}]", this.primaryRequest.getTargetAllocationID(), this.primaryRequest.getPrimaryTerm(), actualTerm);
            }
            TransportReplicationAction.this.acquirePrimaryOperationPermit(indexShard, (ReplicationRequest)this.primaryRequest.getRequest(), ActionListener.wrap(releasable -> this.runWithPrimaryShardReference(new PrimaryShardReference(indexShard, (Releasable)releasable)), e -> {
                if (e instanceof ShardNotInPrimaryModeException) {
                    this.onFailure(new ReplicationOperation.RetryOnPrimaryException(shardId, "shard is not in primary mode", (Throwable)e));
                } else {
                    this.onFailure((Exception)e);
                }
            }));
        }

        void runWithPrimaryShardReference(PrimaryShardReference primaryShardReference) {
            try {
                ClusterState clusterState = TransportReplicationAction.this.clusterService.state();
                IndexMetadata indexMetadata = clusterState.metadata().getIndexSafe(primaryShardReference.routingEntry().index());
                ClusterBlockException blockException = TransportReplicationAction.this.blockExceptions(clusterState, indexMetadata.getIndex().getName());
                if (blockException != null) {
                    TransportReplicationAction.this.logger.trace("cluster is blocked, action failed on primary", (Throwable)blockException);
                    throw blockException;
                }
                if (primaryShardReference.isRelocated()) {
                    primaryShardReference.close();
                    ShardRouting primary = primaryShardReference.routingEntry();
                    assert (primary.relocating()) : "indexShard is marked as relocated but routing isn't" + String.valueOf(primary);
                    DiscoveryNode relocatingNode = clusterState.nodes().get(primary.relocatingNodeId());
                    TransportReplicationAction.this.transportService.sendRequest(relocatingNode, TransportReplicationAction.this.transportPrimaryAction, new ConcreteShardRequest<ReplicationRequest>((ReplicationRequest)this.primaryRequest.getRequest(), primary.allocationId().getRelocationId(), this.primaryRequest.getPrimaryTerm()), TransportReplicationAction.this.transportOptions, new ActionListenerResponseHandler<Response>(this, this.onCompletionListener, TransportReplicationAction.this::newResponseInstance){

                        @Override
                        public void handleResponse(Response response) {
                            super.handleResponse(response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            super.handleException(exp);
                        }
                    });
                } else {
                    ActionListener<ReplicationResponse> responseListener = ActionListener.wrap(response -> {
                        block3: {
                            TransportReplicationAction.this.adaptResponse(response, primaryShardReference.indexShard);
                            if (TransportReplicationAction.this.syncGlobalCheckpointAfterOperation) {
                                try {
                                    primaryShardReference.indexShard.maybeSyncGlobalCheckpoint("post-operation");
                                }
                                catch (Exception e) {
                                    if (Exceptions.firstCause((Throwable)e, (Class[])new Class[]{AlreadyClosedException.class, IndexShardClosedException.class}) != null) break block3;
                                    TransportReplicationAction.this.logger.info((Message)new ParameterizedMessage("{} failed to execute post-operation global checkpoint sync", (Object)primaryShardReference.indexShard.shardId()), (Throwable)e);
                                }
                            }
                        }
                        primaryShardReference.close();
                        this.onCompletionListener.onResponse((ReplicationResponse)response);
                    }, e -> this.handleException(primaryShardReference, (Exception)e));
                    new ReplicationOperation((ReplicationRequest)this.primaryRequest.getRequest(), primaryShardReference, responseListener.map(result -> result.finalResponseIfSuccessful), TransportReplicationAction.this.newReplicasProxy(), TransportReplicationAction.this.logger, TransportReplicationAction.this.threadPool, TransportReplicationAction.this.actionName, this.primaryRequest.getPrimaryTerm(), TransportReplicationAction.this.initialRetryBackoffBound, TransportReplicationAction.this.retryTimeout).execute();
                }
            }
            catch (Exception e2) {
                Releasables.closeIgnoringException(primaryShardReference);
                this.onFailure(e2);
            }
        }

        private void handleException(PrimaryShardReference primaryShardReference, Exception e) {
            Releasables.closeIgnoringException(primaryShardReference);
            this.onFailure(e);
        }

        @Override
        public void onFailure(Exception e) {
            this.onCompletionListener.onFailure(e);
        }
    }

    public static class ConcreteShardRequest<R extends TransportRequest>
    extends TransportRequest {
        private final String targetAllocationID;
        private final long primaryTerm;
        private final R request;

        public ConcreteShardRequest(R request, String targetAllocationID, long primaryTerm) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(targetAllocationID);
            this.request = request;
            this.targetAllocationID = targetAllocationID;
            this.primaryTerm = primaryTerm;
        }

        @Override
        public void setParentTask(String parentTaskNode, long parentTaskId) {
            this.request.setParentTask(parentTaskNode, parentTaskId);
        }

        @Override
        public void setParentTask(TaskId taskId) {
            ((TransportRequest)this.request).setParentTask(taskId);
        }

        @Override
        public TaskId getParentTask() {
            return ((TransportRequest)this.request).getParentTask();
        }

        @Override
        public String getDescription() {
            return "[" + this.request.getDescription() + "] for aID [" + this.targetAllocationID + "] and term [" + this.primaryTerm + "]";
        }

        public ConcreteShardRequest(StreamInput in, Writeable.Reader<R> reader) throws IOException {
            this.targetAllocationID = in.readString();
            this.primaryTerm = in.readVLong();
            this.request = (TransportRequest)reader.read(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.targetAllocationID);
            out.writeVLong(this.primaryTerm);
            ((TransportRequest)this.request).writeTo(out);
        }

        public R getRequest() {
            return this.request;
        }

        public String getTargetAllocationID() {
            return this.targetAllocationID;
        }

        public long getPrimaryTerm() {
            return this.primaryTerm;
        }

        public String toString() {
            return "request: " + String.valueOf(this.request) + ", target allocation id: " + this.targetAllocationID + ", primary term: " + this.primaryTerm;
        }
    }

    private final class AsyncReplicaAction
    extends AbstractRunnable
    implements ActionListener<Releasable> {
        private final ActionListener<ReplicaResponse> onCompletionListener;
        private final IndexShard replica;
        private final ClusterStateObserver observer;
        private final ConcreteReplicaRequest<ReplicaRequest> replicaRequest;

        AsyncReplicaAction(ConcreteReplicaRequest<ReplicaRequest> replicaRequest, ActionListener<ReplicaResponse> onCompletionListener) {
            this.observer = new ClusterStateObserver(TransportReplicationAction.this.clusterService, null, TransportReplicationAction.this.logger);
            this.replicaRequest = replicaRequest;
            this.onCompletionListener = onCompletionListener;
            ShardId shardId = ((ReplicationRequest)replicaRequest.getRequest()).shardId();
            assert (shardId != null) : "request shardId must be set";
            this.replica = TransportReplicationAction.this.getIndexShard(shardId);
        }

        @Override
        public void onResponse(Releasable releasable) {
            try {
                assert (this.replica.getActiveOperationsCount() != 0) : "must perform shard operation under a permit";
                ReplicaResult replicaResult = TransportReplicationAction.this.shardOperationOnReplica((ReplicationRequest)this.replicaRequest.getRequest(), this.replica);
                replicaResult.runPostReplicaActions(ActionListener.wrap(r -> {
                    ReplicaResponse response = new ReplicaResponse(this.replica.getLocalCheckpoint(), this.replica.getLastSyncedGlobalCheckpoint());
                    releasable.close();
                    if (TransportReplicationAction.this.logger.isTraceEnabled()) {
                        TransportReplicationAction.this.logger.trace("action [{}] completed on shard [{}] for request [{}]", (Object)TransportReplicationAction.this.transportReplicaAction, (Object)((ReplicationRequest)this.replicaRequest.getRequest()).shardId(), this.replicaRequest.getRequest());
                    }
                    this.onCompletionListener.onResponse(response);
                }, e -> {
                    Releasables.closeIgnoringException(releasable);
                    this.responseWithFailure((Exception)e);
                }));
            }
            catch (Exception e2) {
                Releasables.closeIgnoringException(releasable);
                this.onFailure(e2);
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (e instanceof RetryOnReplicaException) {
                TransportReplicationAction.this.logger.trace(() -> new ParameterizedMessage("Retrying operation on replica, action [{}], request [{}]", (Object)TransportReplicationAction.this.transportReplicaAction, this.replicaRequest.getRequest()), (Throwable)e);
                ((ReplicationRequest)this.replicaRequest.getRequest()).onRetry();
                this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        TransportReplicationAction.this.transportService.sendRequest(TransportReplicationAction.this.clusterService.localNode(), TransportReplicationAction.this.transportReplicaAction, AsyncReplicaAction.this.replicaRequest, new ActionListenerResponseHandler<ReplicaResponse>(AsyncReplicaAction.this.onCompletionListener, ReplicaResponse::new));
                    }

                    @Override
                    public void onClusterServiceClose() {
                        AsyncReplicaAction.this.responseWithFailure(new NodeClosedException(TransportReplicationAction.this.clusterService.localNode()));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        throw new AssertionError((Object)"Cannot happen: there is not timeout");
                    }
                });
            } else {
                this.responseWithFailure(e);
            }
        }

        protected void responseWithFailure(Exception e) {
            this.onCompletionListener.onFailure(e);
        }

        @Override
        protected void doRun() throws Exception {
            String actualAllocationId = this.replica.routingEntry().allocationId().getId();
            if (!actualAllocationId.equals(this.replicaRequest.getTargetAllocationID())) {
                throw new ShardNotFoundException(this.replica.shardId(), "expected allocation id [{}] but found [{}]", this.replicaRequest.getTargetAllocationID(), actualAllocationId);
            }
            TransportReplicationAction.this.acquireReplicaOperationPermit(this.replica, (ReplicationRequest)this.replicaRequest.getRequest(), this, this.replicaRequest.getPrimaryTerm(), this.replicaRequest.getGlobalCheckpoint(), this.replicaRequest.getMaxSeqNoOfUpdatesOrDeletes());
        }
    }

    protected static final class ConcreteReplicaRequest<R extends TransportRequest>
    extends ConcreteShardRequest<R> {
        private final long globalCheckpoint;
        private final long maxSeqNoOfUpdatesOrDeletes;

        public ConcreteReplicaRequest(R request, String targetAllocationID, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes) {
            super(request, targetAllocationID, primaryTerm);
            this.globalCheckpoint = globalCheckpoint;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
        }

        public ConcreteReplicaRequest(StreamInput in, Writeable.Reader<R> reader) throws IOException {
            super(in, reader);
            this.globalCheckpoint = in.readZLong();
            this.maxSeqNoOfUpdatesOrDeletes = in.readZLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.globalCheckpoint);
            out.writeZLong(this.maxSeqNoOfUpdatesOrDeletes);
        }

        public long getGlobalCheckpoint() {
            return this.globalCheckpoint;
        }

        public long getMaxSeqNoOfUpdatesOrDeletes() {
            return this.maxSeqNoOfUpdatesOrDeletes;
        }

        @Override
        public String toString() {
            return "ConcreteReplicaRequest{targetAllocationID='" + this.getTargetAllocationID() + "', primaryTerm='" + this.getPrimaryTerm() + "', request=" + String.valueOf(this.getRequest()) + ", globalCheckpoint=" + this.globalCheckpoint + ", maxSeqNoOfUpdatesOrDeletes=" + this.maxSeqNoOfUpdatesOrDeletes + "}";
        }
    }

    public static class ReplicaResponse
    extends TransportResponse
    implements ReplicationOperation.ReplicaResponse {
        private final long localCheckpoint;
        private final long globalCheckpoint;

        public ReplicaResponse(long localCheckpoint, long globalCheckpoint) {
            assert (localCheckpoint != -2L);
            this.localCheckpoint = localCheckpoint;
            this.globalCheckpoint = globalCheckpoint;
        }

        public ReplicaResponse(StreamInput in) throws IOException {
            this.localCheckpoint = in.readZLong();
            this.globalCheckpoint = in.readZLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.localCheckpoint);
            out.writeZLong(this.globalCheckpoint);
        }

        @Override
        public long localCheckpoint() {
            return this.localCheckpoint;
        }

        @Override
        public long globalCheckpoint() {
            return this.globalCheckpoint;
        }
    }

    class PrimaryShardReference
    implements Releasable,
    ReplicationOperation.Primary<Request, ReplicaRequest, PrimaryResult<ReplicaRequest, Response>> {
        protected final IndexShard indexShard;
        private final Releasable operationLock;

        PrimaryShardReference(IndexShard indexShard, Releasable operationLock) {
            this.indexShard = indexShard;
            this.operationLock = operationLock;
        }

        @Override
        public void close() {
            this.operationLock.close();
        }

        @Override
        public ShardRouting routingEntry() {
            return this.indexShard.routingEntry();
        }

        public boolean isRelocated() {
            return this.indexShard.isRelocatedPrimary();
        }

        @Override
        public void failShard(String reason, Exception e) {
            try {
                this.indexShard.failShard(reason, e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
        }

        @Override
        public void perform(Request request, ActionListener<PrimaryResult<ReplicaRequest, Response>> listener) {
            if (Assertions.ENABLED) {
                listener = listener.map(result -> {
                    assert (result.replicaRequest() == null || result.finalFailure == null) : "a replica request [" + String.valueOf(result.replicaRequest()) + "] with a primary failure [" + String.valueOf(result.finalFailure) + "]";
                    return result;
                });
            }
            assert (this.indexShard.getActiveOperationsCount() != 0) : "must perform shard operation under a permit";
            TransportReplicationAction.this.shardOperationOnPrimary(request, this.indexShard, listener);
        }

        @Override
        public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
            this.indexShard.updateLocalCheckpointForShard(allocationId, checkpoint);
        }

        @Override
        public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
            this.indexShard.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
        }

        @Override
        public long localCheckpoint() {
            return this.indexShard.getLocalCheckpoint();
        }

        @Override
        public long globalCheckpoint() {
            return this.indexShard.getLastSyncedGlobalCheckpoint();
        }

        @Override
        public long computedGlobalCheckpoint() {
            return this.indexShard.getLastKnownGlobalCheckpoint();
        }

        @Override
        public long maxSeqNoOfUpdatesOrDeletes() {
            return this.indexShard.getMaxSeqNoOfUpdatesOrDeletes();
        }

        @Override
        public ReplicationGroup getReplicationGroup() {
            return this.indexShard.getReplicationGroup();
        }

        @Override
        public PendingReplicationActions getPendingReplicationActions() {
            return this.indexShard.getPendingReplicationActions();
        }
    }

    public static class RetryOnReplicaException
    extends ElasticsearchException {
        public RetryOnReplicaException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public RetryOnReplicaException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class ReplicaResult {
        final Exception finalFailure;

        public ReplicaResult(Exception finalFailure) {
            this.finalFailure = finalFailure;
        }

        public ReplicaResult() {
            this(null);
        }

        public void runPostReplicaActions(ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                listener.onResponse(null);
            }
        }
    }

    public static class PrimaryResult<ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
    implements ReplicationOperation.PrimaryResult<ReplicaRequest> {
        protected final ReplicaRequest replicaRequest;
        public final Response finalResponseIfSuccessful;
        public final Exception finalFailure;

        public PrimaryResult(ReplicaRequest replicaRequest, Response finalResponseIfSuccessful, Exception finalFailure) {
            assert (finalFailure != null ^ finalResponseIfSuccessful != null) : "either a response or a failure has to be not null, found [" + String.valueOf(finalFailure) + "] failure and [" + String.valueOf(finalResponseIfSuccessful) + "] response";
            this.replicaRequest = replicaRequest;
            this.finalResponseIfSuccessful = finalResponseIfSuccessful;
            this.finalFailure = finalFailure;
        }

        public PrimaryResult(ReplicaRequest replicaRequest, Response replicationResponse) {
            this(replicaRequest, replicationResponse, null);
        }

        @Override
        public ReplicaRequest replicaRequest() {
            return this.replicaRequest;
        }

        @Override
        public void setShardInfo(ReplicationResponse.ShardInfo shardInfo) {
            if (this.finalResponseIfSuccessful != null) {
                ((ReplicationResponse)this.finalResponseIfSuccessful).setShardInfo(shardInfo);
            }
        }

        @Override
        public void runPostReplicationActions(ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                listener.onResponse(null);
            }
        }
    }
}

