/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public class NodeClient
extends AbstractClient {
    private Map<ActionType, TransportAction> actions;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<ActionType, TransportAction> actions) {
        this.actions = actions;
    }

    @Override
    public void close() {
    }

    @Override
    public <Req extends TransportRequest, Resp extends TransportResponse> CompletableFuture<Resp> execute(ActionType<Resp> action, Req request) {
        return this.transportAction(action).execute(request);
    }

    private <Request extends TransportRequest, Response extends TransportResponse> TransportAction<Request, Response> transportAction(ActionType<Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + String.valueOf(action) + "] to execute");
        }
        return transportAction;
    }
}

