/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class ClusterIndexHealth
implements Iterable<ClusterShardHealth>,
Writeable {
    private final String index;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final int activeShards;
    private final int relocatingShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final int activePrimaryShards;
    private final ClusterHealthStatus status;
    private final Map<Integer, ClusterShardHealth> shards;

    public ClusterIndexHealth(IndexMetadata indexMetadata, IndexRoutingTable indexRoutingTable) {
        this.index = indexMetadata.getIndex().getName();
        this.numberOfShards = indexMetadata.getNumberOfShards();
        this.numberOfReplicas = indexMetadata.getNumberOfReplicas();
        this.shards = new HashMap<Integer, ClusterShardHealth>();
        for (IndexShardRoutingTable shardRoutingTable : indexRoutingTable) {
            int shardId = shardRoutingTable.shardId().id();
            this.shards.put(shardId, new ClusterShardHealth(shardId, shardRoutingTable));
        }
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        for (ClusterShardHealth shardHealth : this.shards.values()) {
            if (shardHealth.isPrimaryActive()) {
                ++computeActivePrimaryShards;
            }
            computeActiveShards += shardHealth.getActiveShards();
            computeRelocatingShards += shardHealth.getRelocatingShards();
            computeInitializingShards += shardHealth.getInitializingShards();
            computeUnassignedShards += shardHealth.getUnassignedShards();
            if (shardHealth.getStatus() == ClusterHealthStatus.RED) {
                computeStatus = ClusterHealthStatus.RED;
                continue;
            }
            if (shardHealth.getStatus() != ClusterHealthStatus.YELLOW || computeStatus == ClusterHealthStatus.RED) continue;
            computeStatus = ClusterHealthStatus.YELLOW;
        }
        if (this.shards.isEmpty()) {
            computeStatus = ClusterHealthStatus.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
    }

    public ClusterIndexHealth(StreamInput in) throws IOException {
        this.index = in.readString();
        this.numberOfShards = in.readVInt();
        this.numberOfReplicas = in.readVInt();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        this.shards = new HashMap<Integer, ClusterShardHealth>(size);
        for (int i = 0; i < size; ++i) {
            ClusterShardHealth shardHealth = new ClusterShardHealth(in);
            this.shards.put(shardHealth.getShardId(), shardHealth);
        }
    }

    public String getIndex() {
        return this.index;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<Integer, ClusterShardHealth> getShards() {
        return this.shards;
    }

    @Override
    public Iterator<ClusterShardHealth> iterator() {
        return this.shards.values().iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.numberOfShards);
        out.writeVInt(this.numberOfReplicas);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeByte(this.status.value());
        out.writeCollection(this.shards.values());
    }

    public String toString() {
        return "ClusterIndexHealth{index='" + this.index + "', numberOfShards=" + this.numberOfShards + ", numberOfReplicas=" + this.numberOfReplicas + ", activeShards=" + this.activeShards + ", relocatingShards=" + this.relocatingShards + ", initializingShards=" + this.initializingShards + ", unassignedShards=" + this.unassignedShards + ", activePrimaryShards=" + this.activePrimaryShards + ", status=" + String.valueOf(this.status) + ", shards.size=" + String.valueOf(this.shards == null ? "null" : Integer.valueOf(this.shards.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterIndexHealth that = (ClusterIndexHealth)o;
        return Objects.equals(this.index, that.index) && this.numberOfShards == that.numberOfShards && this.numberOfReplicas == that.numberOfReplicas && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && this.activePrimaryShards == that.activePrimaryShards && this.status == that.status && Objects.equals(this.shards, that.shards);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.numberOfShards, this.numberOfReplicas, this.activeShards, this.relocatingShards, this.initializingShards, this.unassignedShards, this.activePrimaryShards, this.status, this.shards);
    }
}

