/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.common.unit.TimeValue;
import io.crate.execution.ddl.tables.CreateBlobTableRequest;
import io.crate.execution.ddl.tables.CreateTableRequest;
import io.crate.execution.ddl.tables.CreateTableResponse;
import io.crate.execution.ddl.tables.MappingUtil;
import io.crate.metadata.DocReferences;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataCreateIndexService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataCreateIndexService.class);
    private final NodeContext nodeContext;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final boolean forbidPrivateIndexSettings;
    private final Settings settings;
    private final ShardLimitValidator shardLimitValidator;

    public MetadataCreateIndexService(NodeContext nodeContext, Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, ShardLimitValidator shardLimitValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, boolean forbidPrivateIndexSettings) {
        this.nodeContext = nodeContext;
        this.settings = settings;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService);
        this.forbidPrivateIndexSettings = forbidPrivateIndexSettings;
        this.shardLimitValidator = shardLimitValidator;
    }

    public static void validateIndexName(String index, ClusterState state) {
        IndexName.validate(index);
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metadata().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(index).getIndex());
        }
        if (state.metadata().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public <T> ActionListener<ClusterStateUpdateResponse> withWaitForShards(ActionListener<T> listener, String indexName, ActiveShardCount waitForActiveShards, TimeValue ackTimeout, BiFunction<Boolean, Boolean, T> createResponse) {
        return ActionListener.wrap(resp -> {
            if (resp.isAcknowledged()) {
                String[] indexNames = new String[]{indexName};
                this.activeShardsObserver.waitForActiveShards(indexNames, waitForActiveShards, ackTimeout, shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        LOGGER.debug("[{}] index created, but the operation timed out waiting for enough shards to be started.", (Object)indexName);
                    }
                    listener.onResponse(createResponse.apply(resp.isAcknowledged(), (Boolean)shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(createResponse.apply(false, false));
            }
        }, listener::onFailure);
    }

    public void createIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        ActionListener<ClusterStateUpdateResponse> actionListener = this.withWaitForShards(listener, request.index(), request.waitForActiveShards(), request.ackTimeout(), CreateIndexClusterStateUpdateResponse::new);
        Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        this.indexScopedSettings.validate(normalizedSettings, true);
        request.settings(normalizedSettings);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new IndexCreationTask(LOGGER, this.allocationService, request, actionListener, this.indicesService, this.settings, this::validate, this.indexScopedSettings, this.nodeContext));
    }

    public void addBlobTable(CreateBlobTableRequest request, ActionListener<CreateTableResponse> listener) {
        String indexName = request.name().indexNameOrAlias();
        ActionListener<ClusterStateUpdateResponse> stateUpdateListener = this.withWaitForShards(listener, indexName, ActiveShardCount.DEFAULT, request.ackTimeout(), (stateAcked, shardsAcked) -> new CreateTableResponse(stateAcked != false && shardsAcked != false));
        this.clusterService.submitStateUpdateTask("create-blob-table", new CreateBlobTableTask(request, stateUpdateListener, this.indicesService, this.allocationService, this.nodeContext));
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        String index = request.index();
        IndexName.validate(index);
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metadata().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(index).getIndex());
        }
        if (state.metadata().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
        this.validateIndexSettings(request.index(), request.settings(), this.forbidPrivateIndexSettings);
        this.shardLimitValidator.validateShardLimit(request.settings(), state);
    }

    public void validateIndexSettings(String indexName, Settings settings, boolean forbidPrivateIndexSettings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    public List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings) {
        Path resolvedPath;
        String customPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isNullOrEmpty(customPath) && this.env.sharedDataFile() == null) {
            validationErrors.add("path.shared_data must be set in order to use custom data paths");
        } else if (!Strings.isNullOrEmpty(customPath) && (resolvedPath = PathUtils.get(new Path[]{this.env.sharedDataFile()}, customPath)) == null) {
            validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + String.valueOf(this.env.sharedDataFile()) + "]");
        }
        if (forbidPrivateIndexSettings) {
            for (String key : settings.keySet()) {
                Setting<?> setting = this.indexScopedSettings.get(key);
                if (setting == null) {
                    assert (this.indexScopedSettings.isPrivateSetting(key)) : key + " must be a private setting if it is missing";
                    continue;
                }
                if (!setting.isPrivateIndex()) continue;
                validationErrors.add("private index setting [" + key + "] can not be set explicitly");
            }
        }
        return validationErrors;
    }

    static List<String> validateShrinkIndex(ClusterState state, String sourceIndex, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexName, targetIndexSettings);
        assert (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings));
        IndexMetadata.selectShrinkShards(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetadata.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetadata.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void validateSplitIndex(ClusterState state, String sourceIndex, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexName, targetIndexSettings);
        IndexMetadata.selectSplitShard(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
    }

    static IndexMetadata validateResize(ClusterState state, String sourceIndex, String targetIndexName, Settings targetIndexSettings) {
        if (state.metadata().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(targetIndexName).getIndex());
        }
        IndexMetadata sourceMetadata = state.metadata().index(sourceIndex);
        if (sourceMetadata == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must be read-only to resize index. use \"index.blocks.write=true\"");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetadata.getRoutingFactor(sourceMetadata.getNumberOfShards(), IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        return sourceMetadata;
    }

    static void prepareResizeIndexSettings(ClusterState currentState, Settings.Builder indexSettingsBuilder, Index resizeSourceIndex, String resizeIntoName, ResizeType type, boolean copySettings, IndexScopedSettings indexScopedSettings) {
        IndexMetadata sourceMetadata = currentState.metadata().index(resizeSourceIndex.getName());
        if (type == ResizeType.SHRINK) {
            List<String> nodesToAllocateOn = MetadataCreateIndexService.validateShrinkIndex(currentState, resizeSourceIndex.getName(), resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.put(IndexMetadata.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id", Strings.arrayToCommaDelimitedString(nodesToAllocateOn.toArray())).put(IndexMetadata.INDEX_SHRINK_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetadata.INDEX_SHRINK_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
        } else if (type == ResizeType.SPLIT) {
            MetadataCreateIndexService.validateSplitIndex(currentState, resizeSourceIndex.getName(), resizeIntoName, indexSettingsBuilder.build());
        } else {
            throw new IllegalStateException("unknown resize type is " + String.valueOf((Object)type));
        }
        Settings.Builder builder = Settings.builder();
        if (copySettings) {
            for (String key : sourceMetadata.getSettings().keySet()) {
                Setting<?> setting = indexScopedSettings.get(key);
                if (setting == null) {
                    assert (indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                if (indexSettingsBuilder.keys().contains(key)) continue;
                builder.copy(key, sourceMetadata.getSettings());
            }
        } else {
            Predicate<String> sourceSettingsPredicate = s -> (s.startsWith("index.similarity.") || s.startsWith("index.analysis.") || s.startsWith("index.sort.") || s.equals("index.mapping.single_type") || s.equals("index.soft_deletes.enabled")) && !indexSettingsBuilder.keys().contains(s);
            builder.put(sourceMetadata.getSettings().filter(sourceSettingsPredicate));
        }
        indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), sourceMetadata.getCreationVersion()).put("index.version.upgraded", sourceMetadata.getUpgradedVersion()).put(builder.build()).put("index.routing_partition_size", sourceMetadata.getRoutingPartitionSize()).put(IndexMetadata.INDEX_RESIZE_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetadata.INDEX_RESIZE_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
    }

    public static void validateSoftDeletesSetting(Settings settings) {
        if (!IndexSettings.INDEX_SOFT_DELETES_SETTING.get(settings).booleanValue() && IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(settings).onOrAfter(Version.V_5_0_0)) {
            throw new IllegalArgumentException("Creating tables with soft-deletes disabled is no longer supported. Please do not specify a value for setting [soft_deletes.enabled].");
        }
    }

    public static int calculateNumRoutingShards(int numShards, Version indexVersionCreated) {
        if (indexVersionCreated.onOrAfter(Version.V_5_8_0)) {
            int log2MaxNumShards = 10;
            int log2NumShards = 32 - Integer.numberOfLeadingZeros(numShards - 1);
            int numSplits = log2MaxNumShards - log2NumShards;
            numSplits = Math.max(1, numSplits);
            return numShards << numSplits;
        }
        return numShards;
    }

    public ClusterState add(ClusterState currentState, CreateTableRequest request, Settings settings) throws IOException {
        RelationName tableName = request.getTableName();
        String indexName = tableName.indexNameOrAlias();
        MetadataCreateIndexService.validateIndexName(indexName, currentState);
        this.validateIndexSettings(indexName, request.settings(), this.forbidPrivateIndexSettings);
        this.shardLimitValidator.validateShardLimit(settings, currentState);
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        MappingMetadata mapping = new MappingMetadata(Map.of("default", MappingUtil.createMapping(MappingUtil.AllocPosition.forNewTable(), request.pkConstraintName(), DocReferences.applyOid(request.references(), metadataBuilder.columnOidSupplier()), request.pKeyIndices(), request.checkConstraints(), request.partitionedBy(), request.tableColumnPolicy(), request.routingColumn())));
        Settings.Builder indexSettingsBuilder = Settings.builder().put(settings).put("index.uuid", UUIDs.randomBase64UUID()).put("index.creation_date", Instant.now().toEpochMilli());
        Settings idxSettings = indexSettingsBuilder.build();
        int routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(idxSettings) ? IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(idxSettings) : MetadataCreateIndexService.calculateNumRoutingShards(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(idxSettings), idxSettings.getAsVersion("index.version.created", null));
        indexSettingsBuilder.remove(IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
        IndexMetadata tmpImd = IndexMetadata.builder(indexName).settings(indexSettingsBuilder.build()).setRoutingNumShards(routingNumShards).build();
        ActiveShardCount waitForActiveShards = tmpImd.getWaitForActiveShards();
        if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
            throw new IllegalArgumentException("invalid wait_for_active_shards[" + String.valueOf(ActiveShardCount.DEFAULT) + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
        }
        return (ClusterState)this.indicesService.withTempIndexService(tmpImd, indexService -> {
            IndexAnalyzers indexAnalyzers = indexService.indexAnalyzers();
            MetadataCreateIndexService.ensureUsedAnalyzersExist(indexAnalyzers, request.references());
            ClusterState updatedState = MetadataCreateIndexService.addIndex(this.allocationService, indexService, currentState, metadataBuilder, indexName, tmpImd, mapping, List.of(), routingNumShards);
            DocTableInfo docTable = new DocTableInfoFactory(this.nodeContext).create(tableName, updatedState.metadata());
            DocTableInfo.checkTotalColumnsLimit(docTable.ident(), docTable.parameters(), docTable.allColumns().stream());
            return updatedState;
        });
    }

    private static ClusterState addIndex(AllocationService allocationService, IndexService indexService, ClusterState currentState, Metadata.Builder metadataBuilder, String indexName, IndexMetadata tmpImd, MappingMetadata mapping, Iterable<Alias> aliases, int routingNumShards) {
        IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexName).settings(tmpImd.getSettings()).setRoutingNumShards(routingNumShards).state(IndexMetadata.State.OPEN).putMapping(mapping);
        for (int shardId = 0; shardId < tmpImd.getNumberOfShards(); ++shardId) {
            indexMetadataBuilder.primaryTerm(shardId, tmpImd.primaryTerm(shardId));
        }
        for (Alias alias : aliases) {
            AliasMetadata aliasMetadata = new AliasMetadata(alias.name());
            indexMetadataBuilder.putAlias(aliasMetadata);
        }
        IndexMetadata indexMetadata = indexMetadataBuilder.build();
        indexService.getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
        LOGGER.info("[{}] creating index, cause [create-table], shards [{}]/[{}]", (Object)indexName, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas());
        Metadata newMetadata = metadataBuilder.put(indexMetadata, false).build();
        ClusterState newState = ClusterState.builder(currentState).blocks(ClusterBlocks.builder().blocks(currentState.blocks()).updateBlocks(indexMetadata)).metadata(newMetadata).routingTable(RoutingTable.builder(currentState.routingTable()).addAsNew(newMetadata.index(indexName)).build()).build();
        return allocationService.reroute(newState, "index [" + indexName + "] created");
    }

    private static void ensureUsedAnalyzersExist(IndexAnalyzers indexAnalyzers, List<Reference> references) {
        for (Reference ref : references) {
            IndexReference indexRef;
            NamedAnalyzer namedAnalyzer;
            if (!(ref instanceof IndexReference) || (namedAnalyzer = indexAnalyzers.get((indexRef = (IndexReference)ref).analyzer())) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Analyzer \"%s\" not found for column \"%s\"", indexRef.analyzer(), indexRef.column()));
        }
    }

    static class IndexCreationTask
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final IndicesService indicesService;
        private final CreateIndexClusterStateUpdateRequest request;
        private final Logger logger;
        private final AllocationService allocationService;
        private final Settings settings;
        private final IndexValidator validator;
        private final IndexScopedSettings indexScopedSettings;
        private final NodeContext nodeContext;

        IndexCreationTask(Logger logger, AllocationService allocationService, CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener, IndicesService indicesService, Settings settings, IndexValidator validator, IndexScopedSettings indexScopedSettings, NodeContext nodeContext) {
            super(Priority.URGENT, request, listener);
            this.request = request;
            this.logger = logger;
            this.allocationService = allocationService;
            this.indicesService = indicesService;
            this.settings = settings;
            this.validator = validator;
            this.indexScopedSettings = indexScopedSettings;
            this.nodeContext = nodeContext;
        }

        @Override
        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            int routingNumShards;
            IndexMetadata sourceMetadata;
            MappingMetadata mapping;
            this.validator.validate(this.request, currentState);
            for (Alias alias : this.request.aliases()) {
                AliasValidator.validateAlias(alias, this.request.index(), currentState.metadata());
            }
            IndexTemplateMetadata template = null;
            try {
                template = currentState.metadata().templates().get(PartitionName.templateName(this.request.index()));
            }
            catch (Exception alias) {
                // empty catch block
            }
            assert (template == null) : String.format(Locale.ENGLISH, "Found a matching template for index %s, invalid usage.", this.request.index());
            Index recoverFromIndex = this.request.recoverFrom();
            if (recoverFromIndex == null) {
                mapping = new MappingMetadata(Map.of());
            } else {
                IndexMetadata sourceMetadata2 = currentState.metadata().getIndexSafe(recoverFromIndex);
                mapping = sourceMetadata2.mapping();
            }
            Settings.Builder indexSettingsBuilder = Settings.builder().put(this.request.settings()).put("index.uuid", UUIDs.randomBase64UUID()).put("index.creation_date", Instant.now().toEpochMilli()).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), currentState.nodes().getSmallestNonClientNodeVersion());
            if (this.request.resizeType() == null && !this.request.copySettings()) {
                if (indexSettingsBuilder.get("index.number_of_replicas") == null) {
                    indexSettingsBuilder.put("index.number_of_replicas", this.settings.getAsInt("index.number_of_replicas", 1));
                }
                if (this.settings.get("index.auto_expand_replicas") != null && indexSettingsBuilder.get("index.auto_expand_replicas") == null) {
                    indexSettingsBuilder.put("index.auto_expand_replicas", this.settings.get("index.auto_expand_replicas"));
                }
            }
            MetadataCreateIndexService.validateSoftDeletesSetting(indexSettingsBuilder.build());
            IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(this.request.index());
            Settings idxSettings = indexSettingsBuilder.build();
            int numTargetShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(idxSettings);
            Version indexVersionCreated = idxSettings.getAsVersion("index.version.created", null);
            IndexMetadata indexMetadata = sourceMetadata = recoverFromIndex == null ? null : currentState.metadata().getIndexSafe(recoverFromIndex);
            if (sourceMetadata == null || sourceMetadata.getNumberOfShards() == 1) {
                routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(idxSettings) ? IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(idxSettings) : MetadataCreateIndexService.calculateNumRoutingShards(numTargetShards, indexVersionCreated);
            } else {
                assert (!IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(idxSettings)) : "index.number_of_routing_shards should not be present on the target index on resize";
                routingNumShards = sourceMetadata.getRoutingNumShards();
            }
            indexSettingsBuilder.remove(IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
            tmpImdBuilder.setRoutingNumShards(routingNumShards);
            if (recoverFromIndex != null) {
                assert (this.request.resizeType() != null);
                MetadataCreateIndexService.prepareResizeIndexSettings(currentState, indexSettingsBuilder, recoverFromIndex, this.request.index(), this.request.resizeType(), this.request.copySettings(), this.indexScopedSettings);
            }
            Settings actualIndexSettings = indexSettingsBuilder.build();
            tmpImdBuilder.settings(actualIndexSettings);
            if (recoverFromIndex != null) {
                long primaryTerm = IntStream.range(0, sourceMetadata.getNumberOfShards()).mapToLong(sourceMetadata::primaryTerm).max().getAsLong();
                for (int shardId = 0; shardId < tmpImdBuilder.numberOfShards(); ++shardId) {
                    tmpImdBuilder.primaryTerm(shardId, primaryTerm);
                }
            }
            IndexMetadata tmpImd = tmpImdBuilder.build();
            ActiveShardCount waitForActiveShards = this.request.waitForActiveShards();
            if (waitForActiveShards == ActiveShardCount.DEFAULT) {
                waitForActiveShards = tmpImd.getWaitForActiveShards();
            }
            if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                throw new IllegalArgumentException("invalid wait_for_active_shards[" + String.valueOf(this.request.waitForActiveShards()) + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
            }
            return (ClusterState)this.indicesService.withTempIndexService(tmpImd, indexService -> {
                ClusterState updatedState = MetadataCreateIndexService.addIndex(this.allocationService, indexService, currentState, Metadata.builder(currentState.metadata()), this.request.index(), tmpImd, mapping, this.request.aliases(), routingNumShards);
                if (!IndexName.isDangling(this.request.index())) {
                    RelationName relationName = RelationName.fromIndexName(this.request.index());
                    new DocTableInfoFactory(this.nodeContext).create(relationName, updatedState.metadata());
                }
                return updatedState;
            });
        }

        @Override
        public void onFailure(String source, Exception e) {
            if (e instanceof ResourceAlreadyExistsException) {
                this.logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            } else {
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            }
            super.onFailure(source, e);
        }
    }

    static interface IndexValidator {
        public void validate(CreateIndexClusterStateUpdateRequest var1, ClusterState var2);
    }

    static class CreateBlobTableTask
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final IndicesService indicesService;
        private final CreateBlobTableRequest request;
        private final AllocationService allocationService;
        private final NodeContext nodeContext;

        public CreateBlobTableTask(CreateBlobTableRequest request, ActionListener<ClusterStateUpdateResponse> listener, IndicesService indicesService, AllocationService allocationService, NodeContext nodeContext) {
            super(Priority.HIGH, request, listener);
            this.request = request;
            this.indicesService = indicesService;
            this.allocationService = allocationService;
            this.nodeContext = nodeContext;
        }

        @Override
        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            String indexName = this.request.name().indexNameOrAlias();
            Version versionCreated = currentState.nodes().getSmallestNonClientNodeVersion();
            Settings settings = Settings.builder().put(this.request.settings()).put("index.uuid", UUIDs.randomBase64UUID()).put("index.creation_date", Instant.now().toEpochMilli()).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), versionCreated).build();
            int numShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
            IndexMetadata indexMetadata = IndexMetadata.builder(indexName).settings(settings).build();
            return (ClusterState)this.indicesService.withTempIndexService(indexMetadata, indexService -> {
                ClusterState updatedState = MetadataCreateIndexService.addIndex(this.allocationService, indexService, currentState, Metadata.builder(currentState.metadata()), indexName, indexMetadata, new MappingMetadata(Map.of()), List.of(), MetadataCreateIndexService.calculateNumRoutingShards(numShards, versionCreated));
                new DocTableInfoFactory(this.nodeContext).create(this.request.name(), updatedState.metadata());
                return updatedState;
            });
        }
    }
}

