/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;

public class MetadataUpdateSettingsService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;

    @Inject
    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
    }

    public void updateSettings(final UpdateSettingsRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings, false, true);
        for (String key : normalizedSettings.keySet()) {
            Setting<?> setting = this.indexScopedSettings.get(key);
            assert (setting != null) : "unknown setting: " + key + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key.replace("index.", ""));
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        AckedClusterStateUpdateTask<ClusterStateUpdateResponse> updateTask = new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, Priority.URGENT, (AckedRequest)request, listener){
            final /* synthetic */ MetadataUpdateSettingsService this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Index[] concreteIndices = IndexNameExpressionResolver.concreteIndices(currentState, request);
                return this.this$0.updateState(currentState, concreteIndices, skippedSettings, closedSettings, openSettings);
            }
        };
        this.clusterService.submitStateUpdateTask("update-settings", updateTask);
    }

    public ClusterState updateState(ClusterState currentState, Index[] concreteIndices, Set<String> skippedSettings, Settings closedSettings, Settings openSettings) {
        Settings finalSettings;
        Settings.Builder indexSettings;
        Settings.Builder updates;
        IndexMetadata indexMetadata;
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        HashSet<Index> openIndices = new HashSet<Index>();
        HashSet<Index> closeIndices = new HashSet<Index>();
        String[] actualIndices = new String[concreteIndices.length];
        for (int i2 = 0; i2 < concreteIndices.length; ++i2) {
            Index index = concreteIndices[i2];
            actualIndices[i2] = index.getName();
            IndexMetadata metadata = currentState.metadata().getIndexSafe(index);
            if (metadata.getState() == IndexMetadata.State.OPEN) {
                openIndices.add(index);
                continue;
            }
            closeIndices.add(index);
        }
        if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
        }
        if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
            int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
            int totalNewShards = Arrays.stream(concreteIndices).mapToInt(i -> MetadataUpdateSettingsService.getTotalNewShards(i, currentState, updatedNumberOfReplicas)).sum();
            Optional<String> error = this.shardLimitValidator.checkShardLimit(totalNewShards, currentState);
            if (error.isPresent()) {
                ValidationException ex = new ValidationException();
                ex.addValidationError(error.get());
                throw ex;
            }
            routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
            metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
            LOGGER.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_READ_ONLY_BLOCK, IndexMetadata.INDEX_READ_ONLY_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK, IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_METADATA_BLOCK, IndexMetadata.INDEX_BLOCKS_METADATA_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_WRITE_BLOCK, IndexMetadata.INDEX_BLOCKS_WRITE_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetadata.INDEX_READ_BLOCK, IndexMetadata.INDEX_BLOCKS_READ_SETTING, openSettings);
        for (Index index : openIndices) {
            indexMetadata = metadataBuilder.getSafe(index);
            updates = Settings.builder();
            indexSettings = Settings.builder().put(indexMetadata.getSettings());
            if (!this.indexScopedSettings.updateDynamicSettings(openSettings, indexSettings, updates, index.getName())) continue;
            finalSettings = indexSettings.build();
            this.indexScopedSettings.validate(finalSettings.filter(k -> !this.indexScopedSettings.isPrivateSetting((String)k)), true);
            metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
        }
        for (Index index : closeIndices) {
            indexMetadata = metadataBuilder.getSafe(index);
            updates = Settings.builder();
            indexSettings = Settings.builder().put(indexMetadata.getSettings());
            if (!this.indexScopedSettings.updateSettings(closedSettings, indexSettings, updates, index.getName())) continue;
            finalSettings = indexSettings.build();
            this.indexScopedSettings.validate(finalSettings.filter(k -> !this.indexScopedSettings.isPrivateSetting((String)k)), true);
            metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
        }
        for (String index : actualIndices) {
            if (IndexSettings.same(currentState.metadata().index(index).getSettings(), metadataBuilder.get(index).getSettings())) continue;
            IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(index));
            builder.settingsVersion(1L + builder.settingsVersion());
            metadataBuilder.put(builder);
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
        updatedState = this.allocationService.reroute(updatedState, "settings update");
        try {
            IndexMetadata updatedMetadata;
            IndexMetadata currentMetadata;
            for (Index index : openIndices) {
                currentMetadata = currentState.metadata().getIndexSafe(index);
                updatedMetadata = updatedState.metadata().getIndexSafe(index);
                this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
            }
            for (Index index : closeIndices) {
                currentMetadata = currentState.metadata().getIndexSafe(index);
                updatedMetadata = updatedState.metadata().getIndexSafe(index);
                this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return updatedState;
    }

    public static int getTotalNewShards(Index index, ClusterState currentState, int updatedNumberOfReplicas) {
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        int shardsInIndex = indexMetadata.getNumberOfShards();
        int oldNumberOfReplicas = indexMetadata.getNumberOfReplicas();
        int replicaIncrease = updatedNumberOfReplicas - oldNumberOfReplicas;
        return replicaIncrease * shardsInIndex;
    }

    public static void maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    blocks.addIndexBlock(index, block);
                    continue;
                }
                blocks.removeIndexBlock(index, block);
            }
        }
    }
}

