/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import io.crate.common.exceptions.Exceptions;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.jetbrains.annotations.Nullable;

public class FailedShard {
    private final ShardRouting routingEntry;
    private final String message;
    private final Exception failure;
    private final boolean markAsStale;

    public FailedShard(ShardRouting routingEntry, String message, Exception failure, boolean markAsStale) {
        assert (routingEntry.assignedToNode()) : "only assigned shards can be failed " + String.valueOf(routingEntry);
        this.routingEntry = routingEntry;
        this.message = message;
        this.failure = failure;
        this.markAsStale = markAsStale;
    }

    public String toString() {
        return "failed shard, shard " + String.valueOf(this.routingEntry) + ", message [" + this.message + "], markAsStale [" + this.markAsStale + "], failure [" + (this.failure == null ? "null" : Exceptions.stackTrace((Throwable)this.failure)) + "]";
    }

    public ShardRouting getRoutingEntry() {
        return this.routingEntry;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Exception getFailure() {
        return this.failure;
    }

    public boolean markAsStale() {
        return this.markAsStale;
    }
}

