/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class ChildMemoryCircuitBreaker
implements CircuitBreaker {
    private final long memoryBytesLimit;
    private final AtomicLong used;
    private final AtomicLong trippedCount;
    private final Logger logger;
    private final CircuitBreakerService parent;
    private final String name;
    private final LongSupplier freeSupplier;

    public ChildMemoryCircuitBreaker(BreakerSettings settings, Logger logger, CircuitBreakerService parent) {
        this(settings, null, logger, parent);
    }

    public ChildMemoryCircuitBreaker(BreakerSettings settings, ChildMemoryCircuitBreaker oldBreaker, Logger logger, CircuitBreakerService parent) {
        this.name = settings.getName();
        this.memoryBytesLimit = settings.getLimit();
        this.freeSupplier = this.memoryBytesLimit == -1L ? () -> Long.MAX_VALUE : (this.memoryBytesLimit == 0L ? () -> 0L : () -> this.getLimit() - this.getUsed());
        if (oldBreaker == null) {
            this.used = new AtomicLong(0L);
            this.trippedCount = new AtomicLong(0L);
        } else {
            this.used = oldBreaker.used;
            this.trippedCount = oldBreaker.trippedCount;
        }
        this.logger = logger;
        if (logger.isTraceEnabled()) {
            logger.trace("creating ChildCircuitBreaker with settings {}", (Object)settings);
        }
        this.parent = parent;
    }

    private void circuitBreak(String fieldName, long bytesAdded, long bytesUsed) {
        this.trippedCount.incrementAndGet();
        throw new CircuitBreakingException(bytesAdded, bytesUsed, this.memoryBytesLimit, fieldName);
    }

    @Override
    public double addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
        if (this.memoryBytesLimit == 0L) {
            this.circuitBreak(label, bytes, -1L);
        }
        long newUsed = this.memoryBytesLimit == -1L ? this.noLimit(bytes, label) : this.limit(bytes, label);
        try {
            this.parent.checkParentLimit(bytes, label);
        }
        catch (CircuitBreakingException e) {
            this.addWithoutBreaking(-bytes);
            throw e;
        }
        return newUsed;
    }

    private long noLimit(long bytes, String label) {
        long newUsed = this.used.addAndGet(bytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: [-1b]]", (Object)this.name, (Object)new ByteSizeValue(bytes), (Object)label, (Object)new ByteSizeValue(newUsed));
        }
        return newUsed;
    }

    private long limit(long bytes, String label) {
        long newUsed;
        long currentUsed;
        do {
            currentUsed = this.used.get();
            newUsed = currentUsed + bytes;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: {} [{}]]", (Object)this.name, (Object)ByteSizeValue.humanReadableBytes(bytes), (Object)label, (Object)ByteSizeValue.humanReadableBytes(newUsed), (Object)this.memoryBytesLimit, (Object)ByteSizeValue.humanReadableBytes(this.memoryBytesLimit));
            }
            if (this.memoryBytesLimit <= 0L || newUsed <= this.memoryBytesLimit) continue;
            this.logger.warn("[{}] New used memory {} [{}] for data of [{}] would be larger than configured breaker: {} [{}], breaking", (Object)this.name, (Object)newUsed, (Object)ByteSizeValue.humanReadableBytes(newUsed), (Object)label, (Object)this.memoryBytesLimit, (Object)ByteSizeValue.humanReadableBytes(this.memoryBytesLimit));
            this.circuitBreak(label, bytes, newUsed);
        } while (!this.used.compareAndSet(currentUsed, newUsed));
        return newUsed;
    }

    @Override
    public long addWithoutBreaking(long bytes) {
        long u = this.used.addAndGet(bytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] Adjusted breaker by [{}] bytes, now [{}]", (Object)this.name, (Object)bytes, (Object)u);
        }
        assert (u >= 0L) : "Used bytes: [" + u + "] must be >= 0";
        return u;
    }

    @Override
    public long getUsed() {
        return this.used.get();
    }

    @Override
    public long getLimit() {
        return this.memoryBytesLimit;
    }

    @Override
    public long getTrippedCount() {
        return this.trippedCount.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getFree() {
        return this.freeSupplier.getAsLong();
    }
}

