/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;

public final class ReleasableBytesReference
implements Releasable,
BytesReference {
    public static final Releasable NO_OP = () -> {};
    private final BytesReference delegate;
    private final AbstractRefCounted refCounted;

    public ReleasableBytesReference(BytesReference delegate, Releasable releasable) {
        this.delegate = delegate;
        this.refCounted = new RefCountedReleasable(releasable);
    }

    private ReleasableBytesReference(BytesReference delegate, AbstractRefCounted refCounted) {
        this.delegate = delegate;
        this.refCounted = refCounted;
        refCounted.incRef();
    }

    public static ReleasableBytesReference wrap(BytesReference reference) {
        return new ReleasableBytesReference(reference, NO_OP);
    }

    public int refCount() {
        return this.refCounted.refCount();
    }

    public ReleasableBytesReference retain() {
        this.refCounted.incRef();
        return this;
    }

    public ReleasableBytesReference retainedSlice(int from, int length) {
        return new ReleasableBytesReference(this.delegate.slice(from, length), this.refCounted);
    }

    @Override
    public void close() {
        this.refCounted.decRef();
    }

    @Override
    public byte get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int getInt(int index) {
        return this.delegate.getInt(index);
    }

    @Override
    public int indexOf(byte marker, int from) {
        return this.delegate.indexOf(marker, from);
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    @Override
    public BytesReference slice(int from, int length) {
        return this.delegate.slice(from, length);
    }

    @Override
    public long ramBytesUsed() {
        return this.delegate.ramBytesUsed();
    }

    @Override
    public StreamInput streamInput() throws IOException {
        return this.delegate.streamInput();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.delegate.writeTo(os);
    }

    @Override
    public String utf8ToString() {
        return this.delegate.utf8ToString();
    }

    @Override
    public BytesRef toBytesRef() {
        return this.delegate.toBytesRef();
    }

    @Override
    public BytesRefIterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int compareTo(BytesReference o) {
        return this.delegate.compareTo(o);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static final class RefCountedReleasable
    extends AbstractRefCounted {
        private final Releasable releasable;

        RefCountedReleasable(Releasable releasable) {
            super("bytes-reference");
            this.releasable = releasable;
        }

        @Override
        protected void closeInternal() {
            this.releasable.close();
        }
    }
}

