/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import io.crate.common.io.IOUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static boolean exists(Path ... files) {
        for (Path file : files) {
            if (!Files.exists(file, new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    public static boolean isHidden(Path path) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().startsWith(".");
    }

    public static boolean isDesktopServicesStore(Path path) {
        return Constants.MAC_OS_X && Files.isRegularFile(path, new LinkOption[0]) && ".DS_Store".equals(path.getFileName().toString());
    }

    public static void deleteSubDirectories(Path ... paths) throws IOException {
        for (Path path : paths) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path subPath : stream) {
                    if (!Files.isDirectory(subPath, new LinkOption[0])) continue;
                    IOUtils.rm((Path[])new Path[]{subPath});
                }
            }
        }
    }

    public static boolean isAccessibleDirectory(Path directory, Logger logger) {
        assert (directory != null && logger != null);
        if (!Files.exists(directory, new LinkOption[0])) {
            logger.debug("[{}] directory does not exist.", (Object)directory.toAbsolutePath());
            return false;
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            logger.debug("[{}] should be a directory but is not.", (Object)directory.toAbsolutePath());
            return false;
        }
        if (!Files.isReadable(directory)) {
            logger.debug("[{}] directory is not readable.", (Object)directory.toAbsolutePath());
            return false;
        }
        return true;
    }

    public static Path[] files(Path from, DirectoryStream.Filter<Path> filter) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(from, filter);){
            Path[] pathArray = FileSystemUtils.toArray(stream);
            return pathArray;
        }
    }

    public static Path[] files(Path directory, String glob) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, glob);){
            Path[] pathArray = FileSystemUtils.toArray(stream);
            return pathArray;
        }
    }

    private static Path[] toArray(DirectoryStream<Path> stream) {
        return (Path[])StreamSupport.stream(stream.spliterator(), false).toArray(Path[]::new);
    }
}

