/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Locale;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.lucene.util.SetOnce;

@Plugin(category="Converter", name="NodeAndClusterIdConverter")
@ConverterKeys(value={"node_and_cluster_id"})
public final class NodeAndClusterIdConverter
extends LogEventPatternConverter {
    private static final SetOnce<String> NODE_AND_CLUSTER_ID = new SetOnce();

    public static NodeAndClusterIdConverter newInstance(String[] options) {
        return new NodeAndClusterIdConverter();
    }

    public NodeAndClusterIdConverter() {
        super("NodeAndClusterId", "node_and_cluster_id");
    }

    public static void setNodeIdAndClusterId(String nodeId, String clusterUUID) {
        NODE_AND_CLUSTER_ID.set((Object)NodeAndClusterIdConverter.formatIds(clusterUUID, nodeId));
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (NODE_AND_CLUSTER_ID.get() != null) {
            toAppendTo.append((String)NODE_AND_CLUSTER_ID.get());
        }
    }

    private static String formatIds(String clusterUUID, String nodeId) {
        return String.format(Locale.ROOT, "\"cluster.uuid\": \"%s\", \"node.id\": \"%s\"", clusterUUID, nodeId);
    }
}

