/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.recycler.DequeRecycler;
import org.elasticsearch.common.recycler.Recycler;

public class ConcurrentDequeRecycler<T>
extends DequeRecycler<T> {
    final AtomicInteger size = new AtomicInteger();

    public ConcurrentDequeRecycler(Recycler.C<T> c, int maxSize) {
        super(c, new ConcurrentLinkedDeque(), maxSize);
    }

    @Override
    public Recycler.V<T> obtain() {
        Recycler.V v = super.obtain();
        if (v.isRecycled()) {
            this.size.decrementAndGet();
        }
        return v;
    }

    @Override
    protected boolean beforeRelease() {
        return this.size.incrementAndGet() <= this.maxSize;
    }

    @Override
    protected void afterRelease(boolean recycled) {
        if (!recycled) {
            this.size.decrementAndGet();
        }
    }
}

