/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import io.crate.common.unit.TimeValue;
import java.util.Objects;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;

public abstract class Rounding {
    public abstract byte id();

    public abstract long round(long var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static Builder builder(DateTimeUnit unit) {
        return new Builder(unit);
    }

    public static Builder builder(TimeValue interval) {
        return new Builder(interval);
    }

    public static class Builder {
        private final DateTimeUnit unit;
        private final long interval;
        private DateTimeZone timeZone = DateTimeZone.UTC;

        public Builder(DateTimeUnit unit) {
            this.unit = unit;
            this.interval = -1L;
        }

        public Builder(TimeValue interval) {
            this.unit = null;
            if (interval.millis() < 1L) {
                throw new IllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval.millis();
        }

        public Builder timeZone(DateTimeZone timeZone) {
            if (timeZone == null) {
                throw new IllegalArgumentException("Setting null as timezone is not supported");
            }
            this.timeZone = timeZone;
            return this;
        }

        public Rounding build() {
            Rounding timeZoneRounding = this.unit != null ? new TimeUnitRounding(this.unit, this.timeZone) : new TimeIntervalRounding(this.interval, this.timeZone);
            return timeZoneRounding;
        }
    }

    static class TimeIntervalRounding
    extends Rounding {
        static final byte ID = 2;
        private final long interval;
        private final DateTimeZone timeZone;

        TimeIntervalRounding(long interval, DateTimeZone timeZone) {
            if (interval < 1L) {
                throw new IllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval;
            this.timeZone = timeZone;
        }

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public long round(long utcMillis) {
            long roundedUTC;
            long timeLocal = this.timeZone.convertUTCToLocal(utcMillis);
            long rounded = TimeIntervalRounding.roundKey(timeLocal, this.interval) * this.interval;
            if (!this.isInDSTGap(rounded)) {
                roundedUTC = this.timeZone.convertLocalToUTC(rounded, true, utcMillis);
                long transition = this.timeZone.previousTransition(utcMillis);
                if (transition != utcMillis && transition > roundedUTC) {
                    roundedUTC = this.round(transition - 1L);
                }
            } else {
                roundedUTC = this.timeZone.previousTransition(utcMillis) + 1L;
            }
            return roundedUTC;
        }

        private static long roundKey(long value, long interval) {
            if (value < 0L) {
                return (value - interval + 1L) / interval;
            }
            return value / interval;
        }

        private boolean isInDSTGap(long instantLocal) {
            int offset;
            if (this.timeZone.isFixed()) {
                return false;
            }
            int offsetLocal = this.timeZone.getOffset(instantLocal);
            if (offsetLocal != (offset = this.timeZone.getOffset(instantLocal - (long)offsetLocal))) {
                long nextAdjusted;
                long nextLocal = this.timeZone.nextTransition(instantLocal - (long)offsetLocal);
                if (nextLocal == instantLocal - (long)offsetLocal) {
                    nextLocal = Long.MAX_VALUE;
                }
                if ((nextAdjusted = this.timeZone.nextTransition(instantLocal - (long)offset)) == instantLocal - (long)offset) {
                    nextAdjusted = Long.MAX_VALUE;
                }
                if (nextLocal != nextAdjusted) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.interval, this.timeZone);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeIntervalRounding other = (TimeIntervalRounding)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.timeZone, other.timeZone);
        }
    }

    static class TimeUnitRounding
    extends Rounding {
        static final byte ID = 1;
        private final DateTimeUnit unit;
        private final DateTimeField field;
        private final DateTimeZone timeZone;
        private final boolean unitRoundsToMidnight;

        TimeUnitRounding(DateTimeUnit unit, DateTimeZone timeZone) {
            this.unit = unit;
            this.field = unit.field(timeZone);
            this.unitRoundsToMidnight = this.field.getDurationField().getUnitMillis() > 3600000L;
            this.timeZone = timeZone;
        }

        @Override
        public byte id() {
            return 1;
        }

        private long previousTransition(long utcMillis) {
            long previousTransition;
            int offsetAtInputTime = this.timeZone.getOffset(utcMillis);
            do {
                if ((previousTransition = this.timeZone.previousTransition(utcMillis)) == utcMillis) {
                    return Long.MAX_VALUE;
                }
                assert (previousTransition < utcMillis);
            } while (this.timeZone.getOffset(utcMillis = previousTransition) == offsetAtInputTime);
            return utcMillis;
        }

        @Override
        public long round(long utcMillis) {
            if (this.timeZone.isFixed()) {
                return this.field.roundFloor(utcMillis);
            }
            if (this.unitRoundsToMidnight) {
                long anyLocalStartOfDay = this.field.roundFloor(utcMillis);
                long previousTransition = this.previousTransition(anyLocalStartOfDay);
                if (previousTransition == Long.MAX_VALUE) {
                    return anyLocalStartOfDay;
                }
                long currentOffset = this.timeZone.getOffset(anyLocalStartOfDay);
                long previousOffset = this.timeZone.getOffset(previousTransition);
                assert (currentOffset != previousOffset);
                long alsoLocalStartOfDay = anyLocalStartOfDay + currentOffset - previousOffset;
                if (alsoLocalStartOfDay <= previousTransition) {
                    return alsoLocalStartOfDay;
                }
                return anyLocalStartOfDay;
            }
            while (true) {
                long rounded = this.field.roundFloor(utcMillis);
                long previousTransition = this.previousTransition(utcMillis);
                if (previousTransition == Long.MAX_VALUE || previousTransition < rounded) {
                    return rounded;
                }
                assert (previousTransition < utcMillis);
                utcMillis = previousTransition;
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.unit, this.timeZone});
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeUnitRounding other = (TimeUnitRounding)obj;
            return Objects.equals((Object)this.unit, (Object)other.unit) && Objects.equals(this.timeZone, other.timeZone);
        }

        public String toString() {
            return "[" + String.valueOf(this.timeZone) + "][" + String.valueOf((Object)this.unit) + "]";
        }
    }
}

