/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ConcurrentCollections {
    static final int AGGRESSIVE_CONCURRENCY_LEVEL = Math.max(Runtime.getRuntime().availableProcessors() * 2, 16);

    public static <K, V> ConcurrentMap<K, V> newConcurrentMapWithAggressiveConcurrency() {
        return ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(16);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMapWithAggressiveConcurrency(int initalCapacity) {
        return new ConcurrentHashMap(initalCapacity, 0.75f, AGGRESSIVE_CONCURRENCY_LEVEL);
    }

    private ConcurrentCollections() {
    }
}

