/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import io.crate.common.SuppressForbidden;
import io.crate.common.exceptions.Exceptions;
import java.util.AbstractQueue;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;
import org.elasticsearch.node.Node;

public class EsExecutors {
    public static final Setting<Integer> PROCESSORS_SETTING = Setting.intSetting("processors", Runtime.getRuntime().availableProcessors(), 1, Setting.Property.NodeScope);
    private static final Executor DIRECT_EXECUTOR = new DirectExecutor();

    public static int numberOfProcessors(Settings settings) {
        return PROCESSORS_SETTING.get(settings);
    }

    public static PrioritizedEsThreadPoolExecutor newSinglePrioritizing(String name, ThreadFactory threadFactory, ScheduledExecutorService timer) {
        return new PrioritizedEsThreadPoolExecutor(name, 1, 1, 0L, TimeUnit.MILLISECONDS, threadFactory, timer);
    }

    public static EsThreadPoolExecutor newScaling(String name, int min, int max, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        ExecutorScalingQueue<Runnable> queue = new ExecutorScalingQueue<Runnable>();
        EsThreadPoolExecutor executor = new EsThreadPoolExecutor(name, min, max, keepAliveTime, unit, queue, threadFactory, new ForceQueuePolicy());
        queue.executor = executor;
        return executor;
    }

    public static EsThreadPoolExecutor newFixed(String name, int size, int queueCapacity, ThreadFactory threadFactory) {
        AbstractQueue queue = queueCapacity < 0 ? new LinkedTransferQueue() : new SizeBlockingQueue(new LinkedTransferQueue(), queueCapacity);
        return new EsThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), threadFactory, new EsAbortPolicy());
    }

    public static Throwable rethrowErrors(Runnable runnable) {
        block6: {
            if (runnable instanceof RunnableFuture) {
                RunnableFuture runnableFuture = (RunnableFuture)runnable;
                try {
                    runnableFuture.get();
                }
                catch (Exception e) {
                    assert (e instanceof CancellationException || e instanceof InterruptedException || e instanceof ExecutionException) : e;
                    Optional maybeError = Exceptions.maybeError((Throwable)e);
                    if (maybeError.isPresent()) {
                        throw (Error)maybeError.get();
                    }
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(e instanceof ExecutionException)) break block6;
                    return e.getCause();
                }
            }
        }
        return null;
    }

    public static Executor directExecutor() {
        return DIRECT_EXECUTOR;
    }

    public static String threadName(Settings settings, String namePrefix) {
        if (Node.NODE_NAME_SETTING.exists(settings)) {
            return EsExecutors.threadName(Node.NODE_NAME_SETTING.get(settings), namePrefix);
        }
        return EsExecutors.threadName("", namePrefix);
    }

    public static String threadName(String nodeName, String namePrefix) {
        return "cratedb" + (nodeName.isEmpty() ? "" : "[") + nodeName + (nodeName.isEmpty() ? "" : "]") + "[" + namePrefix + "]";
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String nodeName, String namePrefix) {
        assert (nodeName != null && !nodeName.isEmpty());
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(nodeName, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        return new EsThreadFactory(namePrefix);
    }

    private EsExecutors() {
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ThreadPoolExecutor executor;

        ExecutorScalingQueue() {
        }

        @Override
        public boolean offer(E e) {
            if (!this.tryTransfer(e)) {
                int left = this.executor.getMaximumPoolSize() - this.executor.getCorePoolSize();
                if (left > 0) {
                    return false;
                }
                return super.offer(e);
            }
            return true;
        }

        @Override
        public void put(E e) {
            super.offer(e);
        }

        @Override
        public boolean add(E e) {
            return super.offer(e);
        }

        @Override
        public boolean offer(E e, long timeout, TimeUnit unit) {
            return super.offer(e);
        }
    }

    static class ForceQueuePolicy
    implements XRejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                assert (executor.getQueue() instanceof ExecutorScalingQueue);
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public long rejected() {
            return 0L;
        }
    }

    static class EsThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        EsThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            this.group = Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class DirectExecutor
    implements Executor {
        @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
        DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
            EsExecutors.rethrowErrors(command);
        }
    }
}

