/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.TieredMergePolicy;

final class EsTieredMergePolicy
extends FilterMergePolicy {
    final TieredMergePolicy regularMergePolicy;
    final TieredMergePolicy forcedMergePolicy;

    EsTieredMergePolicy() {
        super((MergePolicy)new TieredMergePolicy());
        this.regularMergePolicy = (TieredMergePolicy)this.in;
        this.forcedMergePolicy = new TieredMergePolicy();
        this.forcedMergePolicy.setMaxMergedSegmentMB(Double.POSITIVE_INFINITY);
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.forcedMergePolicy.findForcedMerges(infos, maxSegmentCount, segmentsToMerge, mergeContext);
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.forcedMergePolicy.findForcedDeletesMerges(infos, mergeContext);
    }

    public void setForceMergeDeletesPctAllowed(double forceMergeDeletesPctAllowed) {
        this.regularMergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
        this.forcedMergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
    }

    public void setFloorSegmentMB(double mbFrac) {
        this.regularMergePolicy.setFloorSegmentMB(mbFrac);
        this.forcedMergePolicy.setFloorSegmentMB(mbFrac);
    }

    public void setMaxMergeAtOnce(int maxMergeAtOnce) {
        this.regularMergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
        this.forcedMergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
    }

    public void setMaxMergedSegmentMB(double mbFrac) {
        this.regularMergePolicy.setMaxMergedSegmentMB(mbFrac);
    }

    public void setSegmentsPerTier(double segmentsPerTier) {
        this.regularMergePolicy.setSegmentsPerTier(segmentsPerTier);
        this.forcedMergePolicy.setSegmentsPerTier(segmentsPerTier);
    }

    public void setDeletesPctAllowed(double deletesPctAllowed) {
        this.regularMergePolicy.setDeletesPctAllowed(deletesPctAllowed);
        this.forcedMergePolicy.setDeletesPctAllowed(deletesPctAllowed);
    }
}

