/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import io.crate.metadata.NodeContext;
import io.crate.metadata.table.TableInfo;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.CompositeIndexEventListener;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.store.FsDirectoryFactory;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.threadpool.ThreadPool;

public final class IndexModule {
    public static final Setting<Boolean> NODE_STORE_ALLOW_MMAP = Setting.boolSetting("node.store.allow_mmap", true, Setting.Property.NodeScope);
    private static final FsDirectoryFactory DEFAULT_DIRECTORY_FACTORY = new FsDirectoryFactory();
    public static final Setting<String> INDEX_STORE_TYPE_SETTING = new Setting("index.store.type", "fs", Function.identity(), DataTypes.STRING, Setting.Property.IndexScope, Setting.Property.NodeScope, Setting.Property.Final);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_ENABLED_SETTING = Setting.boolSetting("index.queries.cache.enabled", true, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_QUERY_CACHE_EVERYTHING_SETTING = Setting.boolSetting("index.queries.cache.everything", false, Setting.Property.IndexScope);
    private final IndexSettings indexSettings;
    private final AnalysisRegistry analysisRegistry;
    private final Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders;
    private final Set<IndexEventListener> indexEventListeners = new HashSet<IndexEventListener>();
    private final Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories;
    private final List<IndexingOperationListener> indexOperationListeners = new ArrayList<IndexingOperationListener>();
    private final AtomicBoolean frozen = new AtomicBoolean(false);

    public IndexModule(IndexSettings indexSettings, AnalysisRegistry analysisRegistry, Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders, Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories) {
        this.indexSettings = indexSettings;
        this.analysisRegistry = analysisRegistry;
        this.engineFactoryProviders = engineFactoryProviders;
        this.directoryFactories = Collections.unmodifiableMap(directoryFactories);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer, Consumer<T> validator) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer, validator);
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public Index getIndex() {
        return this.indexSettings.getIndex();
    }

    public void addIndexEventListener(IndexEventListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexEventListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexEventListeners.add(listener);
    }

    public void addIndexOperationListener(IndexingOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexOperationListeners.add(listener);
    }

    IndexEventListener freeze() {
        if (this.frozen.compareAndSet(false, true)) {
            return new CompositeIndexEventListener(this.indexSettings, this.indexEventListeners);
        }
        throw new IllegalStateException("already frozen");
    }

    public static boolean isBuiltinType(String storeType) {
        for (Type type : Type.values()) {
            if (!type.match(storeType)) continue;
            return true;
        }
        return false;
    }

    public static Type defaultStoreType(boolean allowMmap) {
        if (allowMmap && Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return Type.HYBRIDFS;
        }
        return Type.NIOFS;
    }

    public IndexService newIndexService(NodeContext nodeContext, IndexService.IndexCreationContext indexCreationContext, NodeEnvironment environment, IndexService.ShardStoreDeleter shardStoreDeleter, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, QueryCache indicesQueryCache, Supplier<TableInfo> getTable) throws IOException {
        IndexEventListener eventListener = this.freeze();
        eventListener.beforeIndexCreated(this.indexSettings.getIndex(), this.indexSettings.getSettings());
        IndexStorePlugin.DirectoryFactory directoryFactory = IndexModule.getDirectoryFactory(this.indexSettings, this.directoryFactories);
        Object queryCache = this.indexSettings.getValue(INDEX_QUERY_CACHE_ENABLED_SETTING) != false ? indicesQueryCache : DisabledQueryCache.instance();
        return new IndexService(nodeContext, this.indexSettings, indexCreationContext, environment, shardStoreDeleter, this.analysisRegistry, this.engineFactoryProviders, circuitBreakerService, bigArrays, threadPool, (QueryCache)queryCache, directoryFactory, eventListener, getTable, this.indexOperationListeners);
    }

    private static IndexStorePlugin.DirectoryFactory getDirectoryFactory(IndexSettings indexSettings, Map<String, IndexStorePlugin.DirectoryFactory> indexStoreFactories) {
        IndexStorePlugin.DirectoryFactory factory;
        String storeType = indexSettings.getValue(INDEX_STORE_TYPE_SETTING);
        Boolean allowMmap = NODE_STORE_ALLOW_MMAP.getWithFallback(indexSettings.getNodeSettings());
        Type type = storeType.isEmpty() || Type.FS.getSettingsKey().equals(storeType) ? IndexModule.defaultStoreType(allowMmap) : (IndexModule.isBuiltinType(storeType) ? Type.fromSettingsKey(storeType) : null);
        if (!(allowMmap.booleanValue() || type != Type.MMAPFS && type != Type.HYBRIDFS)) {
            throw new IllegalArgumentException("store type [" + storeType + "] is not allowed because mmap is disabled");
        }
        if (storeType.isEmpty() || IndexModule.isBuiltinType(storeType)) {
            factory = DEFAULT_DIRECTORY_FACTORY;
        } else {
            factory = indexStoreFactories.get(storeType);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown store type [" + storeType + "]");
            }
        }
        return factory;
    }

    private void ensureNotFrozen() {
        if (this.frozen.get()) {
            throw new IllegalStateException("Can't modify IndexModule once the index service has been created");
        }
    }

    public static enum Type {
        HYBRIDFS("hybridfs"),
        NIOFS("niofs"),
        MMAPFS("mmapfs"),
        FS("fs");

        private final String settingsKey;
        private static final Map<String, Type> TYPES;

        private Type(String settingsKey) {
            this.settingsKey = settingsKey;
        }

        public String getSettingsKey() {
            return this.settingsKey;
        }

        public static Type fromSettingsKey(String key) {
            Type type = TYPES.get(key);
            if (type == null) {
                throw new IllegalArgumentException("no matching store type for [" + key + "]");
            }
            return type;
        }

        public boolean match(String setting) {
            return this.getSettingsKey().equals(setting);
        }

        static {
            HashMap<String, Type> types = new HashMap<String, Type>(4);
            for (Type type : Type.values()) {
                types.put(type.settingsKey, type);
            }
            TYPES = Collections.unmodifiableMap(types);
        }
    }
}

