/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import io.crate.common.unit.TimeValue;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public final class EngineConfig {
    private final ShardId shardId;
    private final IndexSettings indexSettings;
    private final ByteSizeValue indexingBufferSize;
    private volatile boolean enableGcDeletes = true;
    private final TimeValue flushMergesAfter;
    private final String codecName;
    private final ThreadPool threadPool;
    private final Store store;
    private final MergePolicy mergePolicy;
    private final Analyzer analyzer;
    private final CodecService codecService;
    private final Engine.EventListener eventListener;
    private final QueryCache queryCache;
    private final QueryCachingPolicy queryCachingPolicy;
    private final List<ReferenceManager.RefreshListener> externalRefreshListeners = new ArrayList<ReferenceManager.RefreshListener>();
    private final List<ReferenceManager.RefreshListener> internalRefreshListeners = new ArrayList<ReferenceManager.RefreshListener>();
    private final CircuitBreakerService circuitBreakerService;
    private final LongSupplier globalCheckpointSupplier;
    private final Supplier<RetentionLeases> retentionLeasesSupplier;
    private final LongSupplier primaryTermSupplier;
    private final TombstoneDocSupplier tombstoneDocSupplier;
    public static final Setting<String> INDEX_CODEC_SETTING = new Setting<String>("index.codec", "default", s -> switch (s) {
        case "default", "best_compression", "lucene_default" -> s;
        default -> {
            if (!Codec.availableCodecs().contains(s)) {
                throw new IllegalArgumentException("unknown value for [index.codec] must be one of [default, best_compression] but was: " + s);
            }
            yield s;
        }
    }, DataTypes.STRING, Setting.Property.IndexScope, Setting.Property.NodeScope);
    private final TranslogConfig translogConfig;

    public Supplier<RetentionLeases> retentionLeasesSupplier() {
        return this.retentionLeasesSupplier;
    }

    public EngineConfig(ShardId shardId, ThreadPool threadPool, IndexSettings indexSettings, Store store, MergePolicy mergePolicy, Analyzer analyzer, CodecService codecService, Engine.EventListener eventListener, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, TranslogConfig translogConfig, TimeValue flushMergesAfter, List<ReferenceManager.RefreshListener> externalRefreshListeners, List<ReferenceManager.RefreshListener> internalRefreshListeners, CircuitBreakerService circuitBreakerService, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier, LongSupplier primaryTermSupplier, TombstoneDocSupplier tombstoneDocSupplier) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.threadPool = threadPool;
        this.store = store;
        this.mergePolicy = mergePolicy;
        this.analyzer = analyzer;
        this.codecService = codecService;
        this.eventListener = eventListener;
        this.codecName = indexSettings.getValue(INDEX_CODEC_SETTING);
        String escapeHatchProperty = "es.index.memory.max_index_buffer_size";
        String maxBufferSize = System.getProperty("es.index.memory.max_index_buffer_size");
        this.indexingBufferSize = maxBufferSize != null ? MemorySizeValue.parseBytesSizeValueOrHeapRatio(maxBufferSize, "es.index.memory.max_index_buffer_size") : IndexingMemoryController.INDEX_BUFFER_SIZE_SETTING.get(indexSettings.getNodeSettings());
        this.queryCache = queryCache;
        this.queryCachingPolicy = queryCachingPolicy;
        this.translogConfig = translogConfig;
        this.flushMergesAfter = flushMergesAfter;
        this.externalRefreshListeners.addAll(externalRefreshListeners);
        this.internalRefreshListeners.addAll(internalRefreshListeners);
        this.circuitBreakerService = circuitBreakerService;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.retentionLeasesSupplier = Objects.requireNonNull(retentionLeasesSupplier);
        this.primaryTermSupplier = primaryTermSupplier;
        this.tombstoneDocSupplier = tombstoneDocSupplier;
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecService.codec(this.codecName);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Store getStore() {
        return this.store;
    }

    public LongSupplier getGlobalCheckpointSupplier() {
        return this.globalCheckpointSupplier;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public Engine.EventListener getEventListener() {
        return this.eventListener;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public TranslogConfig getTranslogConfig() {
        return this.translogConfig;
    }

    public TimeValue getFlushMergesAfter() {
        return this.flushMergesAfter;
    }

    public List<ReferenceManager.RefreshListener> getExternalRefreshListeners() {
        return this.externalRefreshListeners;
    }

    public List<ReferenceManager.RefreshListener> getInternalRefreshListeners() {
        return this.internalRefreshListeners;
    }

    @Nullable
    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    public LongSupplier getPrimaryTermSupplier() {
        return this.primaryTermSupplier;
    }

    public TombstoneDocSupplier getTombstoneDocSupplier() {
        return this.tombstoneDocSupplier;
    }

    public static interface TombstoneDocSupplier {
        public ParsedDocument newDeleteTombstoneDoc(String var1);

        public ParsedDocument newNoopTombstoneDoc(String var1);
    }
}

