/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import io.crate.metadata.doc.SysColumns;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.SequenceIDFields;
import org.elasticsearch.index.mapper.Uid;

public class ParsedDocument {
    private final Field version;
    private final String id;
    private final SequenceIDFields seqID;
    private final Document document;
    private final BytesReference source;

    public static ParsedDocument createDeleteTombstoneDoc(String index, String id) throws MapperParsingException {
        Document doc = new Document();
        BytesRef idBytes = Uid.encodeId(id);
        doc.add((IndexableField)new Field("_id", idBytes, (IndexableFieldType)SysColumns.ID.FIELD_TYPE));
        NumericDocValuesField version = new NumericDocValuesField(SysColumns.VERSION.name(), -1L);
        doc.add((IndexableField)version);
        SequenceIDFields seqID = SequenceIDFields.emptySeqID();
        doc.add((IndexableField)seqID.seqNo);
        doc.add((IndexableField)seqID.seqNoDocValue);
        doc.add((IndexableField)seqID.primaryTerm);
        return new ParsedDocument((Field)version, seqID, id, doc, new BytesArray("{}")).toTombstone();
    }

    public static ParsedDocument createNoopTombstoneDoc(String index, String reason) throws MapperParsingException {
        Document doc = new Document();
        String id = "";
        NumericDocValuesField version = new NumericDocValuesField(SysColumns.VERSION.name(), -1L);
        doc.add((IndexableField)version);
        SequenceIDFields seqID = SequenceIDFields.emptySeqID();
        doc.add((IndexableField)seqID.seqNo);
        doc.add((IndexableField)seqID.seqNoDocValue);
        doc.add((IndexableField)seqID.primaryTerm);
        ParsedDocument parsedDoc = new ParsedDocument((Field)version, seqID, "", doc, new BytesArray("{}")).toTombstone();
        BytesRef byteRef = new BytesRef((CharSequence)reason);
        doc.add((IndexableField)new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return parsedDoc;
    }

    public ParsedDocument(Field version, SequenceIDFields seqID, String id, Document document, BytesReference source) {
        this.version = version;
        this.seqID = seqID;
        this.id = id;
        this.document = document;
        this.source = source;
    }

    public String id() {
        return this.id;
    }

    public Field version() {
        return this.version;
    }

    public void updateSeqID(long sequenceNumber, long primaryTerm) {
        this.seqID.seqNo.setLongValue(sequenceNumber);
        this.seqID.seqNoDocValue.setLongValue(sequenceNumber);
        this.seqID.primaryTerm.setLongValue(primaryTerm);
    }

    ParsedDocument toTombstone() {
        this.seqID.tombstoneField.setLongValue(1L);
        this.doc().add((IndexableField)this.seqID.tombstoneField);
        return this;
    }

    public Document doc() {
        return this.document;
    }

    public BytesReference source() {
        return this.source;
    }

    public String toString() {
        return "Document id[" + this.id + "] doc [" + String.valueOf(this.document) + "]";
    }
}

