/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import io.crate.lucene.DisableGraphAttribute;
import io.crate.lucene.ExtendedCommonTermsQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.match.ParsedOptions;
import io.crate.metadata.IndexReference;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.QueryBuilder;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;

public class MatchQuery {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(MatchQuery.class));
    static final float DEFAULT_BOOST = 1.0f;
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final ZeroTermsQuery DEFAULT_ZERO_TERMS_QUERY = ZeroTermsQuery.NONE;
    protected final LuceneQueryBuilder.Context context;
    protected final ParsedOptions parsedOptions;

    public MatchQuery(LuceneQueryBuilder.Context context, ParsedOptions parsedOptions) {
        this.context = context;
        this.parsedOptions = parsedOptions;
    }

    protected Analyzer getSafeAnalyzer(Reference ref) {
        String searchAnalyzer = this.parsedOptions.analyzer();
        if (ref instanceof IndexReference) {
            IndexReference indexRef = (IndexReference)ref;
            if (searchAnalyzer == null || searchAnalyzer.equals(indexRef.analyzer())) {
                return this.context.getAnalyzer(indexRef.analyzer());
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column '%s' was indexed with the '%s' analyzer, searching with a different analyzer, '%s' is not supported", indexRef.column(), indexRef.analyzer(), searchAnalyzer));
        }
        if (searchAnalyzer == null || searchAnalyzer.equals("keyword")) {
            return Lucene.KEYWORD_ANALYZER;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column '%s' was indexed with the 'keyword' analyzer, searching with a different analyzer, '%s' is not supported", ref.column(), searchAnalyzer));
    }

    public Query parse(Type type, String fieldName, Object value) {
        Reference ref = this.context.getRef(fieldName);
        if (ref == null) {
            return Queries.newUnmappedFieldQuery(fieldName);
        }
        String field = ref.storageIdent();
        Analyzer analyzer = this.getSafeAnalyzer(ref);
        if (analyzer == Lucene.KEYWORD_ANALYZER) {
            return this.blendTermQuery(new Term(fieldName, value.toString()), ref);
        }
        MatchQueryBuilder builder = new MatchQueryBuilder(analyzer, ref);
        builder.setEnablePositionIncrements(true);
        builder.setAutoGenerateMultiTermSynonymsPhraseQuery(ref.indexType() == IndexType.FULLTEXT);
        int phraseSlop = this.parsedOptions.phraseSlop();
        Query query = null;
        switch (type.ordinal()) {
            case 0: {
                BooleanClause.Occur occur = this.parsedOptions.operator();
                Float commonTermsCutoff = this.parsedOptions.commonTermsCutoff();
                if (commonTermsCutoff == null) {
                    query = builder.createBooleanQuery(field, value.toString(), occur);
                    break;
                }
                query = builder.createCommonTermsQuery(field, value.toString(), occur, occur, commonTermsCutoff.floatValue());
                break;
            }
            case 1: {
                query = builder.createPhraseQuery(field, value.toString(), phraseSlop);
                break;
            }
            case 2: {
                query = builder.createPhrasePrefixQuery(field, value.toString(), phraseSlop, this.parsedOptions.maxExpansions());
                break;
            }
            default: {
                throw new IllegalStateException("No type found for [" + String.valueOf((Object)type) + "]");
            }
        }
        if (query == null) {
            return this.zeroTermsQuery();
        }
        return query;
    }

    protected final Query termQuery(Reference ref, BytesRef value) {
        return new TermQuery(new Term(ref.storageIdent(), value));
    }

    protected Query zeroTermsQuery() {
        ZeroTermsQuery zeroTermsQuery = this.parsedOptions.zeroTermsQuery();
        switch (zeroTermsQuery.ordinal()) {
            case 2: {
                return null;
            }
            case 0: {
                return new MatchNoDocsQuery("Matching no documents because no terms present");
            }
            case 1: {
                return new MatchAllDocsQuery();
            }
        }
        throw new IllegalStateException("unknown zeroTermsQuery " + String.valueOf((Object)zeroTermsQuery));
    }

    protected Query blendPhraseQuery(PhraseQuery query, Reference reference) {
        return query;
    }

    protected Query blendTermsQuery(Term[] terms, Reference ref) {
        SynonymQuery.Builder builder = new SynonymQuery.Builder(ref.storageIdent());
        for (Term term : terms) {
            builder.addTerm(term);
        }
        return builder.build();
    }

    protected Query blendTermQuery(Term term, Reference ref) {
        Fuzziness fuzziness = this.parsedOptions.fuzziness();
        if (fuzziness == null) {
            return this.termQuery(ref, term.bytes());
        }
        if (ref.indexType() == IndexType.NONE) {
            throw new IllegalArgumentException("Cannot search on field [" + String.valueOf(ref.column()) + "] since it is not indexed.");
        }
        int distance = fuzziness.asDistance(term.text());
        MultiTermQuery.RewriteMethod fuzzyRewriteMethod = this.parsedOptions.rewriteMethod();
        int maxExpansions = this.parsedOptions.maxExpansions();
        MultiTermQuery.RewriteMethod rewriteMethod = fuzzyRewriteMethod == null ? FuzzyQuery.defaultRewriteMethod((int)maxExpansions) : fuzzyRewriteMethod;
        return new FuzzyQuery(term, distance, this.parsedOptions.prefixLength(), maxExpansions, this.parsedOptions.transpositions(), rewriteMethod);
    }

    private static Query multiPhraseQuery(String field, TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
        MultiPhraseQuery.Builder mpqb = new MultiPhraseQuery.Builder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    private static Query phraseQuery(String field, TokenStream stream, int slop, boolean enablePosIncrements) throws IOException {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        stream.reset();
        while (stream.incrementToken()) {
            position = enablePosIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
            builder.add(new Term(field, termAtt.getBytesRef()), position);
        }
        return builder.build();
    }

    private class MatchQueryBuilder
    extends QueryBuilder {
        private final Reference reference;

        MatchQueryBuilder(Analyzer analyzer, Reference reference) {
            super(analyzer);
            this.reference = reference;
        }

        protected Query newTermQuery(Term term, float boost) {
            return MatchQuery.this.blendTermQuery(term, this.reference);
        }

        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                this.checkForPositions(field);
                Query query = MatchQuery.phraseQuery(field, stream, slop, this.enablePositionIncrements);
                if (query instanceof PhraseQuery) {
                    return MatchQuery.this.blendPhraseQuery((PhraseQuery)query, this.reference);
                }
                return query;
            }
            catch (IllegalArgumentException e) {
                DEPRECATION_LOGGER.deprecatedAndMaybeLog("match_query_analyze_phrase_not_lenient", e.getMessage(), new Object[0]);
                return Queries.newLenientFieldQuery(field, e);
            }
        }

        protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                this.checkForPositions(field);
                return MatchQuery.multiPhraseQuery(field, stream, slop, this.enablePositionIncrements);
            }
            catch (IllegalArgumentException e) {
                DEPRECATION_LOGGER.deprecatedAndMaybeLog("match_query_analyze_multiphrase_not_lenient", e.getMessage(), new Object[0]);
                return Queries.newLenientFieldQuery(field, e);
            }
        }

        private void checkForPositions(String field) {
            if (this.reference.indexType() != IndexType.FULLTEXT) {
                throw new IllegalStateException("field:[" + field + "] was indexed without position data; cannot run PhraseQuery");
            }
        }

        protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
            Query query;
            block10: {
                assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
                TokenStream source = analyzer.tokenStream(field, queryText);
                try {
                    if (source.hasAttribute(DisableGraphAttribute.class)) {
                        this.setEnableGraphQueries(false);
                    }
                    Query query2 = super.createFieldQuery(source, operator, field, quoted, phraseSlop);
                    this.setEnableGraphQueries(true);
                    query = query2;
                    if (source == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error analyzing query text", e);
                    }
                }
                source.close();
            }
            return query;
        }

        public Query createPhrasePrefixQuery(String field, String queryText, int phraseSlop, int maxExpansions) {
            Query query = this.createFieldQuery(this.getAnalyzer(), BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
            return this.toMultiPhrasePrefix(query, phraseSlop, maxExpansions);
        }

        private Query toMultiPhrasePrefix(Query query, int phraseSlop, int maxExpansions) {
            float boost = 1.0f;
            Query innerQuery = query;
            while (innerQuery instanceof BoostQuery) {
                BoostQuery bq = (BoostQuery)innerQuery;
                boost *= bq.getBoost();
                innerQuery = bq.getQuery();
            }
            if (query instanceof SpanQuery) {
                return this.toSpanQueryPrefix((SpanQuery)query, boost);
            }
            MultiPhrasePrefixQuery prefixQuery = new MultiPhrasePrefixQuery();
            prefixQuery.setMaxExpansions(maxExpansions);
            prefixQuery.setSlop(phraseSlop);
            if (innerQuery instanceof PhraseQuery) {
                PhraseQuery pq = (PhraseQuery)innerQuery;
                Term[] terms = pq.getTerms();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(new Term[]{terms[i]}, positions[i]);
                }
                return boost == 1.0f ? prefixQuery : new BoostQuery((Query)prefixQuery, boost);
            }
            if (innerQuery instanceof MultiPhraseQuery) {
                MultiPhraseQuery pq = (MultiPhraseQuery)innerQuery;
                Term[][] terms = pq.getTermArrays();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(terms[i], positions[i]);
                }
                return boost == 1.0f ? prefixQuery : new BoostQuery((Query)prefixQuery, boost);
            }
            if (innerQuery instanceof TermQuery) {
                prefixQuery.add(((TermQuery)innerQuery).getTerm());
                return boost == 1.0f ? prefixQuery : new BoostQuery((Query)prefixQuery, boost);
            }
            return query;
        }

        private Query toSpanQueryPrefix(SpanQuery query, float boost) {
            if (query instanceof SpanTermQuery) {
                SpanMultiTermQueryWrapper ret = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(((SpanTermQuery)query).getTerm()));
                return boost == 1.0f ? ret : new BoostQuery((Query)ret, boost);
            }
            if (query instanceof SpanNearQuery) {
                SpanNearQuery spanNearQuery = (SpanNearQuery)query;
                SpanQuery[] clauses = spanNearQuery.getClauses();
                if (clauses[clauses.length - 1] instanceof SpanTermQuery) {
                    clauses[clauses.length - 1] = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(((SpanTermQuery)clauses[clauses.length - 1]).getTerm()));
                }
                SpanNearQuery newQuery = new SpanNearQuery(clauses, spanNearQuery.getSlop(), spanNearQuery.isInOrder());
                return boost == 1.0f ? newQuery : new BoostQuery((Query)newQuery, boost);
            }
            if (query instanceof SpanOrQuery) {
                SpanOrQuery orQuery = (SpanOrQuery)query;
                SpanQuery[] clauses = new SpanQuery[orQuery.getClauses().length];
                for (int i = 0; i < clauses.length; ++i) {
                    clauses[i] = (SpanQuery)this.toSpanQueryPrefix(orQuery.getClauses()[i], 1.0f);
                }
                return boost == 1.0f ? new SpanOrQuery(clauses) : new BoostQuery((Query)new SpanOrQuery(clauses), boost);
            }
            return query;
        }

        public Query createCommonTermsQuery(String field, String queryText, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency) {
            Query booleanQuery = this.createBooleanQuery(field, queryText, lowFreqOccur);
            if (booleanQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)booleanQuery;
                return this.boolToExtendedCommonTermsQuery(bq, highFreqOccur, lowFreqOccur, maxTermFrequency);
            }
            return booleanQuery;
        }

        private Query boolToExtendedCommonTermsQuery(BooleanQuery bq, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency) {
            ExtendedCommonTermsQuery query = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency);
            for (BooleanClause clause : bq.clauses()) {
                if (!(clause.getQuery() instanceof TermQuery)) {
                    return bq;
                }
                query.add(((TermQuery)clause.getQuery()).getTerm());
            }
            return query;
        }
    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }

    public static enum ZeroTermsQuery {
        NONE,
        ALL,
        NULL;

    }
}

