/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import io.crate.common.collections.Tuple;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.elasticsearch.Assertions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

final class IndexShardOperationPermits
implements Closeable {
    private final ShardId shardId;
    private final ThreadPool threadPool;
    static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final List<DelayedOperation> delayedOperations = new ArrayList<DelayedOperation>();
    private volatile boolean closed;
    private int queuedBlockOperations;
    private final Map<AtomicBoolean, Tuple<String, StackTraceElement[]>> issuedPermits;

    IndexShardOperationPermits(ShardId shardId, ThreadPool threadPool) {
        this.shardId = shardId;
        this.threadPool = threadPool;
        this.issuedPermits = Assertions.ENABLED ? new ConcurrentHashMap<AtomicBoolean, Tuple<String, StackTraceElement[]>>() : Collections.emptyMap();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Exception> void blockOperations(long timeout, TimeUnit timeUnit, CheckedRunnable<E> onBlocked) throws InterruptedException, TimeoutException, E {
        this.delayOperations();
        try (Releasable ignored = this.acquireAll(timeout, timeUnit);){
            onBlocked.run();
        }
        finally {
            this.releaseDelayedOperations();
        }
    }

    public void asyncBlockOperations(final ActionListener<Releasable> onAcquired, final long timeout, final TimeUnit timeUnit) {
        this.delayOperations();
        this.threadPool.executor("generic").execute(new AbstractRunnable(this){
            final AtomicBoolean released = new AtomicBoolean(false);
            final /* synthetic */ IndexShardOperationPermits this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    this.releaseDelayedOperationsIfNeeded();
                }
                finally {
                    onAcquired.onFailure(e);
                }
            }

            @Override
            protected void doRun() throws Exception {
                Releasable releasable = this.this$0.acquireAll(timeout, timeUnit);
                onAcquired.onResponse(() -> {
                    try {
                        releasable.close();
                    }
                    finally {
                        this.releaseDelayedOperationsIfNeeded();
                    }
                });
            }

            private void releaseDelayedOperationsIfNeeded() {
                if (this.released.compareAndSet(false, true)) {
                    this.this$0.releaseDelayedOperations();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOperations() {
        if (this.closed) {
            throw new IndexShardClosedException(this.shardId);
        }
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0 || this.delayedOperations.isEmpty());
            ++this.queuedBlockOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Releasable acquireAll(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (Assertions.ENABLED) {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                assert (this.queuedBlockOperations > 0);
            }
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, timeout, timeUnit)) {
            AtomicBoolean closed = new AtomicBoolean();
            return () -> {
                if (closed.compareAndSet(false, true)) {
                    assert (this.semaphore.availablePermits() == 0);
                    this.semaphore.release(Integer.MAX_VALUE);
                }
            };
        }
        throw new TimeoutException("timeout while blocking operations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDelayedOperations() {
        List queuedActions;
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0);
            --this.queuedBlockOperations;
            if (this.queuedBlockOperations == 0) {
                queuedActions = new ArrayList<DelayedOperation>(this.delayedOperations);
                this.delayedOperations.clear();
            } else {
                queuedActions = Collections.emptyList();
            }
        }
        if (!queuedActions.isEmpty()) {
            this.threadPool.executor("generic").execute(() -> {
                for (DelayedOperation queuedAction : queuedActions) {
                    this.acquire(queuedAction.listener, null, false, queuedAction.debugInfo, queuedAction.stackTrace);
                }
            });
        }
    }

    public void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, boolean forceExecution, Object debugInfo) {
        StackTraceElement[] stackTrace = Assertions.ENABLED ? Thread.currentThread().getStackTrace() : null;
        this.acquire(onAcquired, executorOnDelay, forceExecution, debugInfo, stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, final boolean forceExecution, Object debugInfo, StackTraceElement[] stackTrace) {
        Releasable releasable;
        if (this.closed) {
            onAcquired.onFailure(new IndexShardClosedException(this.shardId));
            return;
        }
        try {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                if (this.queuedBlockOperations > 0) {
                    ActionListener<Releasable> wrappedListener = executorOnDelay != null ? ActionListener.delegateFailure(onAcquired, (l, r) -> this.threadPool.executor(executorOnDelay).execute(new ActionRunnable<Releasable>(this, l){

                        @Override
                        public boolean isForceExecution() {
                            return forceExecution;
                        }

                        @Override
                        protected void doRun() {
                            this.listener.onResponse(r);
                        }

                        @Override
                        public void onRejection(Exception e) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{r});
                            super.onRejection(e);
                        }
                    })) : onAcquired;
                    this.delayedOperations.add(new DelayedOperation(wrappedListener, debugInfo, stackTrace));
                    return;
                }
                releasable = this.acquire(debugInfo, stackTrace);
            }
        }
        catch (InterruptedException e) {
            onAcquired.onFailure(e);
            return;
        }
        onAcquired.onResponse(releasable);
    }

    private Releasable acquire(Object debugInfo, StackTraceElement[] stackTrace) throws InterruptedException {
        assert (Thread.holdsLock(this));
        if (this.semaphore.tryAcquire(1, 0L, TimeUnit.SECONDS)) {
            AtomicBoolean closed = new AtomicBoolean();
            Releasable releasable = () -> {
                if (closed.compareAndSet(false, true)) {
                    if (Assertions.ENABLED) {
                        Tuple<String, StackTraceElement[]> existing = this.issuedPermits.remove(closed);
                        assert (existing != null);
                    }
                    this.semaphore.release(1);
                }
            };
            if (Assertions.ENABLED) {
                this.issuedPermits.put(closed, (Tuple<String, StackTraceElement[]>)new Tuple((Object)debugInfo.toString(), (Object)stackTrace));
            }
            return releasable;
        }
        throw new IllegalStateException("failed to obtain permit but operations are not delayed");
    }

    int getActiveOperationsCount() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0) {
            return -1;
        }
        return Integer.MAX_VALUE - availablePermits;
    }

    synchronized boolean isBlocked() {
        return this.queuedBlockOperations > 0;
    }

    List<String> getActiveOperations() {
        return this.issuedPermits.values().stream().map(t -> (String)t.v1() + "\n" + Exceptions.formatStackTrace((StackTraceElement[])((StackTraceElement[])t.v2()))).collect(Collectors.toList());
    }

    private static class DelayedOperation {
        private final ActionListener<Releasable> listener;
        private final String debugInfo;
        private final StackTraceElement[] stackTrace;

        private DelayedOperation(ActionListener<Releasable> listener, Object debugInfo, StackTraceElement[] stackTrace) {
            this.listener = listener;
            if (Assertions.ENABLED) {
                this.debugInfo = "[delayed] " + String.valueOf(debugInfo);
                this.stackTrace = stackTrace;
            } else {
                this.debugInfo = null;
                this.stackTrace = null;
            }
        }
    }
}

