/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.gateway.CorruptStateException;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.jetbrains.annotations.Nullable;

public final class ShardStateMetadata
implements Writeable {
    private static final String SHARD_STATE_FILE_PREFIX = "state-";
    private static final String PRIMARY_KEY = "primary";
    private static final String VERSION_KEY = "version";
    private static final String INDEX_UUID_KEY = "index_uuid";
    private static final String ALLOCATION_ID_KEY = "allocation_id";
    public final String indexUUID;
    public final boolean primary;
    @Nullable
    public final AllocationId allocationId;
    public static final MetadataStateFormat<ShardStateMetadata> FORMAT = new MetadataStateFormat<ShardStateMetadata>("state-"){

        @Override
        public ShardStateMetadata fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return null;
            }
            Boolean primary = null;
            String currentFieldName = null;
            String indexUUID = "_na_";
            AllocationId allocationId = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (ShardStateMetadata.PRIMARY_KEY.equals(currentFieldName)) {
                        primary = parser.booleanValue();
                        continue;
                    }
                    if (ShardStateMetadata.INDEX_UUID_KEY.equals(currentFieldName)) {
                        indexUUID = parser.text();
                        continue;
                    }
                    if (ShardStateMetadata.VERSION_KEY.equals(currentFieldName)) continue;
                    throw new CorruptStateException("unexpected field in shard state [" + currentFieldName + "]");
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (ShardStateMetadata.ALLOCATION_ID_KEY.equals(currentFieldName)) {
                        allocationId = AllocationId.fromXContent(parser);
                        continue;
                    }
                    throw new CorruptStateException("unexpected object in shard state [" + currentFieldName + "]");
                }
                throw new CorruptStateException("unexpected token in shard state [" + token.name() + "]");
            }
            if (primary == null) {
                throw new CorruptStateException("missing value for [primary] in shard state");
            }
            return new ShardStateMetadata(primary, indexUUID, allocationId);
        }

        @Override
        public ShardStateMetadata readFrom(StreamInput in) throws IOException {
            return new ShardStateMetadata(in);
        }
    };

    public ShardStateMetadata(boolean primary, String indexUUID, AllocationId allocationId) {
        assert (indexUUID != null);
        this.primary = primary;
        this.indexUUID = indexUUID;
        this.allocationId = allocationId;
    }

    public ShardStateMetadata(StreamInput in) throws IOException {
        this.primary = in.readBoolean();
        this.indexUUID = in.readString();
        this.allocationId = in.readOptionalWriteable(AllocationId::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.primary);
        out.writeString(this.indexUUID);
        out.writeOptionalWriteable(this.allocationId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStateMetadata that = (ShardStateMetadata)o;
        if (this.primary != that.primary) {
            return false;
        }
        if (this.indexUUID != null ? !this.indexUUID.equals(that.indexUUID) : that.indexUUID != null) {
            return false;
        }
        return !(this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null);
    }

    public int hashCode() {
        int result = this.indexUUID != null ? this.indexUUID.hashCode() : 0;
        result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
        result = 31 * result + (this.primary ? 1 : 0);
        return result;
    }

    public String toString() {
        return "primary [" + this.primary + "], allocation [" + String.valueOf(this.allocationId) + "]";
    }
}

