/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.QueryCache;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;

public final class IndicesQueryCache {
    private static final Logger LOGGER = LogManager.getLogger(IndicesQueryCache.class);
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE_SETTING = Setting.memorySizeSetting("indices.queries.cache.size", "10%", Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_CACHE_QUERY_COUNT_SETTING = Setting.intSetting("indices.queries.cache.count", 10000, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING = Setting.boolSetting("indices.queries.cache.all_segments", false, Setting.Property.NodeScope);

    private IndicesQueryCache() {
    }

    public static QueryCache createCache(Settings settings) {
        ByteSizeValue size = INDICES_CACHE_QUERY_SIZE_SETTING.get(settings);
        int count = INDICES_CACHE_QUERY_COUNT_SETTING.get(settings);
        LOGGER.debug("using [node] query cache with size [{}] max filter count [{}]", (Object)size, (Object)count);
        if (INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING.get(settings).booleanValue()) {
            return new LRUQueryCache(count, size.getBytes(), context -> true, 1.0f);
        }
        return new LRUQueryCache(count, size.getBytes());
    }
}

