/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.flush;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.flush.ShardsSyncedFlushResult;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class SyncedFlushService
implements IndexEventListener {
    private static final Logger LOGGER = LogManager.getLogger(SyncedFlushService.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LOGGER);
    public static final String SYNCED_FLUSH_DEPRECATION_MESSAGE = "Synced flush is deprecated and will be removed in CrateDB 5.0";
    private static final String PRE_SYNCED_FLUSH_ACTION_NAME = "internal:indices/flush/synced/pre";
    private static final String SYNCED_FLUSH_ACTION_NAME = "internal:indices/flush/synced/sync";
    private static final String IN_FLIGHT_OPS_ACTION_NAME = "internal:indices/flush/synced/in_flight";
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public SyncedFlushService(IndicesService indicesService, ClusterService clusterService, TransportService transportService) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        transportService.registerRequestHandler(PRE_SYNCED_FLUSH_ACTION_NAME, "flush", PreShardSyncedFlushRequest::new, new PreSyncedFlushTransportHandler());
        transportService.registerRequestHandler(SYNCED_FLUSH_ACTION_NAME, "flush", ShardSyncedFlushRequest::new, new SyncedFlushTransportHandler());
        transportService.registerRequestHandler(IN_FLIGHT_OPS_ACTION_NAME, "same", InFlightOpsRequest::new, new InFlightOpCountTransportHandler());
    }

    @Override
    public void onShardInactive(final IndexShard indexShard) {
        boolean preferNormalFlush = this.clusterService.state().nodes().getMinNodeVersion().onOrAfter(Version.V_4_4_0);
        if (preferNormalFlush) {
            this.performNormalFlushOnInactive(indexShard);
        } else if (indexShard.routingEntry().primary()) {
            this.attemptSyncedFlush(indexShard.shardId(), new ActionListener<ShardsSyncedFlushResult>(){

                @Override
                public void onResponse(ShardsSyncedFlushResult syncedFlushResult) {
                    LOGGER.trace("{} sync flush on inactive shard returned successfully for sync_id: {}", (Object)syncedFlushResult.getShardId(), (Object)syncedFlushResult.syncId());
                }

                @Override
                public void onFailure(Exception e) {
                    LOGGER.debug(() -> new ParameterizedMessage("{} sync flush on inactive shard failed", (Object)indexShard.shardId()), (Throwable)e);
                }
            });
        }
    }

    private void performNormalFlushOnInactive(final IndexShard shard) {
        LOGGER.debug("flushing shard {} on inactive", (Object)shard.routingEntry());
        shard.getThreadPool().executor("flush").execute(new AbstractRunnable(this){

            @Override
            public void onFailure(Exception e) {
                if (shard.state() != IndexShardState.CLOSED) {
                    LOGGER.warn((Message)new ParameterizedMessage("failed to flush shard {} on inactive", (Object)shard.routingEntry()), (Throwable)e);
                }
            }

            @Override
            protected void doRun() {
                shard.flush(new FlushRequest(new String[0]).force(false).waitIfOngoing(false));
            }
        });
    }

    public void attemptSyncedFlush(String[] aliasesOrIndices, IndicesOptions indicesOptions, final ActionListener<SyncedFlushResponse> listener) {
        ClusterState state = this.clusterService.state();
        if (state.nodes().getMinNodeVersion().onOrAfter(Version.V_4_4_0)) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("synced_flush", SYNCED_FLUSH_DEPRECATION_MESSAGE, new Object[0]);
        }
        Index[] concreteIndices = IndexNameExpressionResolver.concreteIndices(state.metadata(), indicesOptions, aliasesOrIndices);
        final ConcurrentHashMap<String, List<ShardsSyncedFlushResult>> results = new ConcurrentHashMap<String, List<ShardsSyncedFlushResult>>();
        int numberOfShards = 0;
        for (Index index : concreteIndices) {
            IndexMetadata indexMetadata = state.metadata().getIndexSafe(index);
            numberOfShards += indexMetadata.getNumberOfShards();
            results.put(index.getName(), Collections.synchronizedList(new ArrayList()));
        }
        if (numberOfShards == 0) {
            listener.onResponse(new SyncedFlushResponse(results));
            return;
        }
        final CountDown countDown = new CountDown(numberOfShards);
        for (Index concreteIndex : concreteIndices) {
            final String index = concreteIndex.getName();
            final IndexMetadata indexMetadata = state.metadata().getIndexSafe(concreteIndex);
            int indexNumberOfShards = indexMetadata.getNumberOfShards();
            for (int shard = 0; shard < indexNumberOfShards; ++shard) {
                final ShardId shardId = new ShardId(indexMetadata.getIndex(), shard);
                this.innerAttemptSyncedFlush(shardId, state, new ActionListener<ShardsSyncedFlushResult>(){

                    @Override
                    public void onResponse(ShardsSyncedFlushResult syncedFlushResult) {
                        ((List)results.get(index)).add(syncedFlushResult);
                        if (countDown.countDown()) {
                            listener.onResponse(new SyncedFlushResponse(results));
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        LOGGER.debug("{} unexpected error while executing synced flush", (Object)shardId);
                        int totalShards = indexMetadata.getNumberOfReplicas() + 1;
                        ((List)results.get(index)).add(new ShardsSyncedFlushResult(shardId, totalShards, e.getMessage()));
                        if (countDown.countDown()) {
                            listener.onResponse(new SyncedFlushResponse(results));
                        }
                    }
                });
            }
        }
    }

    public void attemptSyncedFlush(ShardId shardId, ActionListener<ShardsSyncedFlushResult> actionListener) {
        this.innerAttemptSyncedFlush(shardId, this.clusterService.state(), actionListener);
    }

    private void innerAttemptSyncedFlush(final ShardId shardId, final ClusterState state, final ActionListener<ShardsSyncedFlushResult> actionListener) {
        try {
            final IndexShardRoutingTable shardRoutingTable = this.getShardRoutingTable(shardId, state);
            final List<ShardRouting> activeShards = shardRoutingTable.activeShards();
            final int totalShards = shardRoutingTable.getSize();
            if (activeShards.size() == 0) {
                actionListener.onResponse(new ShardsSyncedFlushResult(shardId, totalShards, "no active shards"));
                return;
            }
            ActionListener<Map<String, PreSyncedFlushResponse>> presyncListener = new ActionListener<Map<String, PreSyncedFlushResponse>>(){
                final /* synthetic */ SyncedFlushService this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onResponse(final Map<String, PreSyncedFlushResponse> presyncResponses) {
                    if (presyncResponses.isEmpty()) {
                        actionListener.onResponse(new ShardsSyncedFlushResult(shardId, totalShards, "all shards failed to commit on pre-sync"));
                        return;
                    }
                    ActionListener<InFlightOpsResponse> inflightOpsListener = new ActionListener<InFlightOpsResponse>(){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void onResponse(InFlightOpsResponse response) {
                            int inflight = response.opCount();
                            assert (inflight >= 0);
                            if (inflight != 0) {
                                this.this$1.actionListener.onResponse(new ShardsSyncedFlushResult(this.this$1.shardId, this.this$1.totalShards, "[" + inflight + "] ongoing operations on primary"));
                            } else {
                                String sharedSyncId = this.this$1.this$0.sharedExistingSyncId(presyncResponses);
                                if (sharedSyncId != null) {
                                    assert (presyncResponses.values().stream().allMatch(r -> r.existingSyncId.equals(sharedSyncId))) : "Not all shards have the same existing sync id [" + sharedSyncId + "], responses [" + String.valueOf(presyncResponses) + "]";
                                    this.this$1.this$0.reportSuccessWithExistingSyncId(this.this$1.shardId, sharedSyncId, this.this$1.activeShards, this.this$1.totalShards, presyncResponses, this.this$1.actionListener);
                                } else {
                                    String syncId = UUIDs.randomBase64UUID();
                                    this.this$1.this$0.sendSyncRequests(syncId, this.this$1.activeShards, this.this$1.state, presyncResponses, this.this$1.shardId, this.this$1.totalShards, this.this$1.actionListener);
                                }
                            }
                        }

                        @Override
                        public void onFailure(Exception e) {
                            this.this$1.actionListener.onFailure(e);
                        }
                    };
                    this.this$0.getInflightOpsCount(shardId, state, shardRoutingTable, inflightOpsListener);
                }

                @Override
                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            };
            this.sendPreSyncRequests(activeShards, state, shardId, presyncListener);
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }

    private String sharedExistingSyncId(Map<String, PreSyncedFlushResponse> preSyncedFlushResponses) {
        String existingSyncId = null;
        for (PreSyncedFlushResponse resp : preSyncedFlushResponses.values()) {
            if (Strings.isNullOrEmpty(resp.existingSyncId)) {
                return null;
            }
            if (existingSyncId == null) {
                existingSyncId = resp.existingSyncId;
            }
            if (existingSyncId.equals(resp.existingSyncId)) continue;
            return null;
        }
        return existingSyncId;
    }

    private void reportSuccessWithExistingSyncId(ShardId shardId, String existingSyncId, List<ShardRouting> shards, int totalShards, Map<String, PreSyncedFlushResponse> preSyncResponses, ActionListener<ShardsSyncedFlushResult> listener) {
        HashMap<ShardRouting, ShardSyncedFlushResponse> results = new HashMap<ShardRouting, ShardSyncedFlushResponse>();
        for (ShardRouting shard : shards) {
            if (!preSyncResponses.containsKey(shard.currentNodeId())) continue;
            results.put(shard, new ShardSyncedFlushResponse());
        }
        listener.onResponse(new ShardsSyncedFlushResult(shardId, existingSyncId, totalShards, results));
    }

    final IndexShardRoutingTable getShardRoutingTable(ShardId shardId, ClusterState state) {
        IndexRoutingTable indexRoutingTable = state.routingTable().index(shardId.getIndexName());
        if (indexRoutingTable == null) {
            IndexMetadata index = state.metadata().index(shardId.getIndex());
            if (index != null && index.getState() == IndexMetadata.State.CLOSE) {
                throw new IndexClosedException(shardId.getIndex());
            }
            throw new IndexNotFoundException(shardId.getIndexName());
        }
        IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shardId.id());
        if (shardRoutingTable == null) {
            throw new ShardNotFoundException(shardId);
        }
        return shardRoutingTable;
    }

    protected void getInflightOpsCount(final ShardId shardId, ClusterState state, IndexShardRoutingTable shardRoutingTable, final ActionListener<InFlightOpsResponse> listener) {
        try {
            ShardRouting primaryShard = shardRoutingTable.primaryShard();
            DiscoveryNode primaryNode = state.nodes().get(primaryShard.currentNodeId());
            if (primaryNode == null) {
                LOGGER.trace("{} failed to resolve node for primary shard {}, skipping sync", (Object)shardId, (Object)primaryShard);
                listener.onResponse(new InFlightOpsResponse(-1));
                return;
            }
            LOGGER.trace("{} retrieving in flight operation count", (Object)shardId);
            this.transportService.sendRequest(primaryNode, IN_FLIGHT_OPS_ACTION_NAME, new InFlightOpsRequest(shardId), new TransportResponseHandler<InFlightOpsResponse>(){

                @Override
                public InFlightOpsResponse read(StreamInput in) throws IOException {
                    return new InFlightOpsResponse(in);
                }

                @Override
                public void handleResponse(InFlightOpsResponse response) {
                    listener.onResponse(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    LOGGER.debug("{} unexpected error while retrieving in flight op count", (Object)shardId);
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private int numDocsOnPrimary(List<ShardRouting> shards, Map<String, PreSyncedFlushResponse> preSyncResponses) {
        for (ShardRouting shard : shards) {
            PreSyncedFlushResponse resp;
            if (!shard.primary() || (resp = preSyncResponses.get(shard.currentNodeId())) == null) continue;
            return resp.numDocs;
        }
        return -1;
    }

    void sendSyncRequests(final String syncId, final List<ShardRouting> shards, ClusterState state, Map<String, PreSyncedFlushResponse> preSyncResponses, final ShardId shardId, final int totalShards, final ActionListener<ShardsSyncedFlushResult> listener) {
        final CountDown countDown = new CountDown(shards.size());
        final ConcurrentHashMap<ShardRouting, ShardSyncedFlushResponse> results = new ConcurrentHashMap<ShardRouting, ShardSyncedFlushResponse>();
        int numDocsOnPrimary = this.numDocsOnPrimary(shards, preSyncResponses);
        for (final ShardRouting shard : shards) {
            final DiscoveryNode node = state.nodes().get(shard.currentNodeId());
            if (node == null) {
                LOGGER.trace("{} is assigned to an unknown node. skipping for sync id [{}]. shard routing {}", (Object)shardId, (Object)syncId, (Object)shard);
                results.put(shard, new ShardSyncedFlushResponse("unknown node"));
                this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                continue;
            }
            PreSyncedFlushResponse preSyncedResponse = preSyncResponses.get(shard.currentNodeId());
            if (preSyncedResponse == null) {
                LOGGER.trace("{} can't resolve expected commit id for current node, skipping for sync id [{}]. shard routing {}", (Object)shardId, (Object)syncId, (Object)shard);
                results.put(shard, new ShardSyncedFlushResponse("no commit id from pre-sync flush"));
                this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                continue;
            }
            if (preSyncedResponse.numDocs != numDocsOnPrimary && preSyncedResponse.numDocs != -1 && numDocsOnPrimary != -1) {
                LOGGER.warn("{} can't to issue sync id [{}] for out of sync replica [{}] with num docs [{}]; num docs on primary [{}]", (Object)shardId, (Object)syncId, (Object)shard, (Object)preSyncedResponse.numDocs, (Object)numDocsOnPrimary);
                results.put(shard, new ShardSyncedFlushResponse("out of sync replica; num docs on replica [" + preSyncedResponse.numDocs + "]; num docs on primary [" + numDocsOnPrimary + "]"));
                this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                continue;
            }
            LOGGER.trace("{} sending synced flush request to {}. sync id [{}].", (Object)shardId, (Object)shard, (Object)syncId);
            this.transportService.sendRequest(node, SYNCED_FLUSH_ACTION_NAME, new ShardSyncedFlushRequest(shard.shardId(), syncId, preSyncedResponse.commitId), new TransportResponseHandler<ShardSyncedFlushResponse>(){
                final /* synthetic */ SyncedFlushService this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ShardSyncedFlushResponse read(StreamInput in) throws IOException {
                    return new ShardSyncedFlushResponse(in);
                }

                @Override
                public void handleResponse(ShardSyncedFlushResponse response) {
                    ShardSyncedFlushResponse existing = results.put(shard, response);
                    assert (existing == null) : "got two answers for node [" + String.valueOf(node) + "]";
                    this.this$0.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                }

                @Override
                public void handleException(TransportException exp) {
                    LOGGER.trace(() -> new ParameterizedMessage("{} error while performing synced flush on [{}], skipping", (Object)shardId, (Object)shard), (Throwable)exp);
                    results.put(shard, new ShardSyncedFlushResponse(exp.getMessage()));
                    this.this$0.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    private void countDownAndSendResponseIfDone(String syncId, List<ShardRouting> shards, ShardId shardId, int totalShards, ActionListener<ShardsSyncedFlushResult> listener, CountDown countDown, Map<ShardRouting, ShardSyncedFlushResponse> results) {
        if (countDown.countDown()) {
            assert (results.size() == shards.size());
            listener.onResponse(new ShardsSyncedFlushResult(shardId, syncId, totalShards, results));
        }
    }

    void sendPreSyncRequests(List<ShardRouting> shards, ClusterState state, final ShardId shardId, final ActionListener<Map<String, PreSyncedFlushResponse>> listener) {
        final CountDown countDown = new CountDown(shards.size());
        final ConcurrentHashMap presyncResponses = new ConcurrentHashMap();
        for (final ShardRouting shard : shards) {
            LOGGER.trace("{} sending pre-synced flush request to {}", (Object)shardId, (Object)shard);
            final DiscoveryNode node = state.nodes().get(shard.currentNodeId());
            if (node == null) {
                LOGGER.trace("{} shard routing {} refers to an unknown node. skipping.", (Object)shardId, (Object)shard);
                if (!countDown.countDown()) continue;
                listener.onResponse(presyncResponses);
                continue;
            }
            this.transportService.sendRequest(node, PRE_SYNCED_FLUSH_ACTION_NAME, new PreShardSyncedFlushRequest(shard.shardId()), new TransportResponseHandler<PreSyncedFlushResponse>(){

                @Override
                public PreSyncedFlushResponse read(StreamInput in) throws IOException {
                    return new PreSyncedFlushResponse(in);
                }

                @Override
                public void handleResponse(PreSyncedFlushResponse response) {
                    PreSyncedFlushResponse existing = presyncResponses.putIfAbsent(node.getId(), response);
                    assert (existing == null) : "got two answers for node [" + String.valueOf(node) + "]";
                    if (countDown.countDown()) {
                        listener.onResponse(presyncResponses);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    LOGGER.trace(() -> new ParameterizedMessage("{} error while performing pre synced flush on [{}], skipping", (Object)shardId, (Object)shard), (Throwable)exp);
                    if (countDown.countDown()) {
                        listener.onResponse(presyncResponses);
                    }
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    private PreSyncedFlushResponse performPreSyncedFlush(PreShardSyncedFlushRequest request) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(request.shardId().getIndex()).getShard(request.shardId().id());
        FlushRequest flushRequest = new FlushRequest(new String[0]).force(false).waitIfOngoing(true);
        LOGGER.trace("{} performing pre sync flush", (Object)request.shardId());
        indexShard.flush(flushRequest);
        CommitStats commitStats = indexShard.commitStats();
        Engine.CommitId commitId = commitStats.getRawCommitId();
        LOGGER.trace("{} pre sync flush done. commit id {}, num docs {}", (Object)request.shardId(), (Object)commitId, (Object)commitStats.getNumDocs());
        return new PreSyncedFlushResponse(commitId, commitStats.getNumDocs(), commitStats.syncId());
    }

    private ShardSyncedFlushResponse performSyncedFlush(ShardSyncedFlushRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().id());
        LOGGER.trace("{} performing sync flush. sync id [{}], expected commit id {}", (Object)request.shardId(), (Object)request.syncId(), (Object)request.expectedCommitId());
        Engine.SyncedFlushResult result = indexShard.syncFlush(request.syncId(), request.expectedCommitId());
        LOGGER.trace("{} sync flush done. sync id [{}], result [{}]", (Object)request.shardId(), (Object)request.syncId(), (Object)result);
        switch (result) {
            case SUCCESS: {
                return new ShardSyncedFlushResponse();
            }
            case COMMIT_MISMATCH: {
                return new ShardSyncedFlushResponse("commit has changed");
            }
            case PENDING_OPERATIONS: {
                return new ShardSyncedFlushResponse("pending operations");
            }
        }
        throw new ElasticsearchException("unknown synced flush result [" + String.valueOf((Object)result) + "]", new Object[0]);
    }

    private InFlightOpsResponse performInFlightOps(InFlightOpsRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().id());
        if (!indexShard.routingEntry().primary()) {
            throw new IllegalStateException("[" + String.valueOf(request.shardId()) + "] expected a primary shard");
        }
        int opCount = indexShard.getActiveOperationsCount();
        return new InFlightOpsResponse(opCount == -1 ? 0 : opCount);
    }

    private final class PreSyncedFlushTransportHandler
    implements TransportRequestHandler<PreShardSyncedFlushRequest> {
        private PreSyncedFlushTransportHandler() {
        }

        @Override
        public void messageReceived(PreShardSyncedFlushRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(SyncedFlushService.this.performPreSyncedFlush(request));
        }
    }

    private final class SyncedFlushTransportHandler
    implements TransportRequestHandler<ShardSyncedFlushRequest> {
        private SyncedFlushTransportHandler() {
        }

        @Override
        public void messageReceived(ShardSyncedFlushRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(SyncedFlushService.this.performSyncedFlush(request));
        }
    }

    private final class InFlightOpCountTransportHandler
    implements TransportRequestHandler<InFlightOpsRequest> {
        private InFlightOpCountTransportHandler() {
        }

        @Override
        public void messageReceived(InFlightOpsRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(SyncedFlushService.this.performInFlightOps(request));
        }
    }

    static final class PreSyncedFlushResponse
    extends TransportResponse {
        static final int UNKNOWN_NUM_DOCS = -1;
        final Engine.CommitId commitId;
        final int numDocs;
        @Nullable
        final String existingSyncId;

        PreSyncedFlushResponse(Engine.CommitId commitId, int numDocs, String existingSyncId) {
            this.commitId = commitId;
            this.numDocs = numDocs;
            this.existingSyncId = existingSyncId;
        }

        public PreSyncedFlushResponse(StreamInput in) throws IOException {
            this.commitId = new Engine.CommitId(in);
            this.numDocs = in.readInt();
            this.existingSyncId = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.commitId.writeTo(out);
            out.writeInt(this.numDocs);
            out.writeOptionalString(this.existingSyncId);
        }
    }

    public static final class ShardSyncedFlushResponse
    extends TransportResponse {
        String failureReason;

        public ShardSyncedFlushResponse() {
            this.failureReason = null;
        }

        public ShardSyncedFlushResponse(String failureReason) {
            this.failureReason = failureReason;
        }

        public ShardSyncedFlushResponse(StreamInput in) throws IOException {
            this.failureReason = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.failureReason);
        }

        public boolean success() {
            return this.failureReason == null;
        }

        public String failureReason() {
            return this.failureReason;
        }

        public String toString() {
            return "ShardSyncedFlushResponse{success=" + this.success() + ", failureReason='" + this.failureReason + "'}";
        }
    }

    static final class InFlightOpsResponse
    extends TransportResponse {
        final int opCount;

        InFlightOpsResponse(int opCount) {
            assert (opCount >= 0) : opCount;
            this.opCount = opCount;
        }

        public InFlightOpsResponse(StreamInput in) throws IOException {
            this.opCount = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.opCount);
        }

        public int opCount() {
            return this.opCount;
        }

        public String toString() {
            return "InFlightOpsResponse{opCount=" + this.opCount + "}";
        }
    }

    public static final class InFlightOpsRequest
    extends TransportRequest {
        private final ShardId shardId;

        public InFlightOpsRequest(ShardId shardId) {
            this.shardId = shardId;
        }

        public InFlightOpsRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public String toString() {
            return "InFlightOpsRequest{shardId=" + String.valueOf(this.shardId) + "}";
        }
    }

    public static final class ShardSyncedFlushRequest
    extends TransportRequest {
        private final String syncId;
        private final Engine.CommitId expectedCommitId;
        private final ShardId shardId;

        public ShardSyncedFlushRequest(ShardId shardId, String syncId, Engine.CommitId expectedCommitId) {
            this.expectedCommitId = expectedCommitId;
            this.shardId = shardId;
            this.syncId = syncId;
        }

        public ShardSyncedFlushRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.expectedCommitId = new Engine.CommitId(in);
            this.syncId = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            this.expectedCommitId.writeTo(out);
            out.writeString(this.syncId);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public String syncId() {
            return this.syncId;
        }

        public Engine.CommitId expectedCommitId() {
            return this.expectedCommitId;
        }

        public String toString() {
            return "ShardSyncedFlushRequest{shardId=" + String.valueOf(this.shardId) + ",syncId='" + this.syncId + "'}";
        }
    }

    public static final class PreShardSyncedFlushRequest
    extends TransportRequest {
        private final ShardId shardId;

        public PreShardSyncedFlushRequest(ShardId shardId) {
            this.shardId = shardId;
        }

        public String toString() {
            return "PreShardSyncedFlushRequest{shardId=" + String.valueOf(this.shardId) + "}";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }

        public PreShardSyncedFlushRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
        }

        public ShardId shardId() {
            return this.shardId;
        }
    }
}

